/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class InputStreamInputFormat
implements InputFormat<LongWritable, Text> {
    private final InputStream _input;

    public InputStreamInputFormat(InputStream is) {
        this._input = is;
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        return new InputSplit[]{new FileSplit(null)};
    }

    public RecordReader<LongWritable, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        return new InputStreamRecordReader(this._input);
    }

    private static class InputStreamRecordReader
    implements RecordReader<LongWritable, Text> {
        private final BufferedReader _reader;

        public InputStreamRecordReader(InputStream is) {
            this._reader = new BufferedReader(new InputStreamReader(is));
        }

        public LongWritable createKey() {
            return new LongWritable();
        }

        public Text createValue() {
            return new Text();
        }

        public float getProgress() throws IOException {
            return 0.0f;
        }

        public long getPos() throws IOException {
            return 0L;
        }

        public boolean next(LongWritable key, Text value) throws IOException {
            String line = this._reader.readLine();
            if (line != null) {
                value.set(line);
            }
            return line != null;
        }

        public void close() throws IOException {
            this._reader.close();
        }
    }
}

