/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.ErrorHandler;
import org.codehaus.commons.compiler.ICompiler;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.compiler.WarningHandler;
import org.codehaus.commons.compiler.util.resource.DirectoryResourceFinder;
import org.codehaus.commons.compiler.util.resource.FileResource;
import org.codehaus.commons.compiler.util.resource.FileResourceCreator;
import org.codehaus.commons.compiler.util.resource.Resource;
import org.codehaus.commons.compiler.util.resource.ResourceCreator;
import org.codehaus.commons.compiler.util.resource.ResourceFinder;
import org.codehaus.commons.nullanalysis.Nullable;
import org.codehaus.janino.AbstractCompiler;
import org.codehaus.janino.ClassFileIClass;
import org.codehaus.janino.ClassLoaderIClassLoader;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.FilterWarningHandler;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.InternalCompilerException;
import org.codehaus.janino.JaninoOption;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.util.Benchmark;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.StringPattern;

public class Compiler
extends AbstractCompiler {
    private static final Logger LOGGER = Logger.getLogger(Compiler.class.getName());
    private ResourceFinder sourceFinder = ResourceFinder.EMPTY_RESOURCE_FINDER;
    @Nullable
    private ResourceFinder classFileFinder = ICompiler.FIND_NEXT_TO_SOURCE_FILE;
    private IClassLoader iClassLoader = new ClassLoaderIClassLoader();
    @Nullable
    private ResourceCreator classFileCreator = ICompiler.CREATE_NEXT_TO_SOURCE_FILE;
    @Nullable
    private Charset encoding;
    private Benchmark benchmark = new Benchmark(false);
    private boolean debugSource;
    private boolean debugLines;
    private boolean debugVars;
    @Nullable
    private WarningHandler warningHandler;
    @Nullable
    private ErrorHandler compileErrorHandler;
    private EnumSet<JaninoOption> options = EnumSet.noneOf(JaninoOption.class);
    private final List<UnitCompiler> parsedCompilationUnits = new ArrayList<UnitCompiler>();
    public static final StringPattern[] DEFAULT_WARNING_HANDLE_PATTERNS = StringPattern.PATTERNS_NONE;

    public Compiler() {
    }

    @Deprecated
    public Compiler(ResourceFinder sourceFinder, IClassLoader parentIClassLoader) {
        this.setSourceFinder(sourceFinder);
        this.setIClassLoader(parentIClassLoader);
    }

    @Deprecated
    public Compiler(File[] sourcePath, File[] classPath, @Nullable File[] extDirs, @Nullable File[] bootClassPath, @Nullable File destinationDirectory, @Nullable String characterEncoding, boolean verbose, boolean debugSource, boolean debugLines, boolean debugVars, StringPattern[] warningHandlePatterns, boolean rebuild) {
        this.setSourcePath(sourcePath);
        this.setClassPath(classPath);
        this.setExtensionDirectories(Compiler.nullToEmptyArray(extDirs, File.class));
        this.setBootClassPath(Compiler.nullToEmptyArray(bootClassPath, File.class));
        this.setDestinationDirectory(destinationDirectory);
        this.setCharacterEncoding(characterEncoding);
        this.setVerbose(verbose);
        this.setDebugSource(debugSource);
        this.setDebugLines(debugLines);
        this.setDebugVars(debugVars);
        this.setClassFileFinder((ResourceFinder)(rebuild ? ResourceFinder.EMPTY_RESOURCE_FINDER : (destinationDirectory == null ? ICompiler.FIND_NEXT_TO_SOURCE_FILE : new DirectoryResourceFinder(destinationDirectory))));
        this.setVerbose(verbose);
        this.setDebugSource(debugSource);
        this.setDebugLines(debugLines);
        this.setDebugVars(debugVars);
        this.setCharacterEncoding(characterEncoding);
        this.setWarningHandler(new FilterWarningHandler(warningHandlePatterns, new WarningHandler(){

            public void handleWarning(@Nullable String handle, String message, @Nullable Location location) {
                StringBuilder sb = new StringBuilder();
                if (location != null) {
                    sb.append(location).append(": ");
                }
                if (handle == null) {
                    sb.append("Warning: ");
                } else {
                    sb.append("Warning ").append(handle).append(": ");
                }
                sb.append(message);
                System.err.println(sb.toString());
            }
        }));
        this.benchmark.report("*** JANINO - an embedded compiler for the Java(TM) programming language");
        this.benchmark.report("*** For more information visit http://janino.codehaus.org");
        this.benchmark.report("Source path", sourcePath);
        this.benchmark.report("Class path", classPath);
        this.benchmark.report("Ext dirs", extDirs);
        this.benchmark.report("Boot class path", bootClassPath);
        this.benchmark.report("Destination directory", destinationDirectory);
        this.benchmark.report("Character encoding", characterEncoding);
        this.benchmark.report("Verbose", new Boolean(verbose));
        this.benchmark.report("Debug source", new Boolean(debugSource));
        this.benchmark.report("Debug lines", new Boolean(debugSource));
        this.benchmark.report("Debug vars", new Boolean(debugSource));
        this.benchmark.report("Warning handle patterns", warningHandlePatterns);
        this.benchmark.report("Rebuild", new Boolean(rebuild));
    }

    private static <T> T[] nullToEmptyArray(@Nullable T[] a, Class<T> elementType) {
        return a != null ? a : (Object[])Array.newInstance(elementType, 0);
    }

    @Override
    public void setCompileErrorHandler(@Nullable ErrorHandler compileErrorHandler) {
        this.compileErrorHandler = compileErrorHandler;
    }

    @Override
    public void setWarningHandler(@Nullable WarningHandler warningHandler) {
        this.warningHandler = warningHandler;
    }

    public EnumSet<JaninoOption> options() {
        return this.options;
    }

    public Compiler options(EnumSet<JaninoOption> options) {
        this.options = options;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(Resource[] sourceResources) throws CompileException, IOException {
        this.benchmark.beginReporting();
        try {
            CompilerIClassLoader iClassLoader = new CompilerIClassLoader(this.sourceFinder, this.classFileFinder, this.iClassLoader);
            this.parsedCompilationUnits.clear();
            for (Resource sourceResource : sourceResources) {
                LOGGER.log(Level.FINE, "Compiling \"{0}\"", sourceResource);
                UnitCompiler uc = new UnitCompiler(this.parseAbstractCompilationUnit(sourceResource.getFileName(), new BufferedInputStream(sourceResource.open()), this.encoding), iClassLoader);
                uc.setCompileErrorHandler(this.compileErrorHandler);
                uc.setWarningHandler(this.warningHandler);
                uc.options(this.options);
                this.parsedCompilationUnits.add(uc);
            }
            for (int i = 0; i < this.parsedCompilationUnits.size(); ++i) {
                ClassFile[] classFiles;
                UnitCompiler unitCompiler = this.parsedCompilationUnits.get(i);
                Java.AbstractCompilationUnit acu = unitCompiler.getAbstractCompilationUnit();
                if (acu.optionalFileName == null) {
                    throw new InternalCompilerException();
                }
                File sourceFile = new File(acu.optionalFileName);
                unitCompiler.setCompileErrorHandler(this.compileErrorHandler);
                unitCompiler.setWarningHandler(this.warningHandler);
                this.benchmark.beginReporting("Compiling compilation unit \"" + sourceFile + "\"");
                try {
                    classFiles = unitCompiler.compileUnit(this.debugSource, this.debugLines, this.debugVars);
                }
                finally {
                    this.benchmark.endReporting();
                }
                this.benchmark.beginReporting("Storing " + classFiles.length + " class file(s) resulting from compilation unit \"" + sourceFile + "\"");
                try {
                    for (ClassFile classFile : classFiles) {
                        this.storeClassFile(classFile, sourceFile);
                    }
                    continue;
                }
                finally {
                    this.benchmark.endReporting();
                }
            }
        }
        finally {
            this.benchmark.endReporting("Compiled " + this.parsedCompilationUnits.size() + " compilation unit(s)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Java.AbstractCompilationUnit parseAbstractCompilationUnit(String fileName, InputStream inputStream, @Nullable Charset encoding) throws CompileException, IOException {
        try {
            Scanner scanner = new Scanner(fileName, new InputStreamReader(inputStream, encoding != null ? encoding : Charset.defaultCharset()));
            Parser parser = new Parser(scanner);
            parser.setWarningHandler(this.warningHandler);
            this.benchmark.beginReporting("Parsing \"" + fileName + "\"");
            try {
                Java.AbstractCompilationUnit abstractCompilationUnit = parser.parseAbstractCompilationUnit();
                this.benchmark.endReporting();
                return abstractCompilationUnit;
            }
            catch (Throwable throwable) {
                this.benchmark.endReporting();
                throw throwable;
            }
        }
        finally {
            inputStream.close();
        }
    }

    public static File getClassFile(String className, File sourceFile, @Nullable File destinationDirectory) {
        if (destinationDirectory != null) {
            return new File(destinationDirectory, ClassFile.getClassFileResourceName(className));
        }
        int idx = className.lastIndexOf(46);
        return new File(sourceFile.getParentFile(), ClassFile.getClassFileResourceName(className.substring(idx + 1)));
    }

    public void storeClassFile(ClassFile classFile, final File sourceFile) throws IOException {
        Object rc;
        String classFileResourceName = ClassFile.getClassFileResourceName(classFile.getThisClassName());
        if (this.classFileCreator != ICompiler.CREATE_NEXT_TO_SOURCE_FILE) {
            rc = this.classFileCreator;
            assert (rc != null);
        } else {
            rc = new FileResourceCreator(){

                protected File getFile(String resourceName) {
                    return new File(sourceFile.getParentFile(), resourceName.substring(resourceName.lastIndexOf(47) + 1));
                }
            };
        }
        OutputStream os = rc.createResource(classFileResourceName);
        try {
            classFile.store(os);
        }
        catch (IOException ioe) {
            try {
                os.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            os = null;
            if (!rc.deleteResource(classFileResourceName)) {
                IOException ioe2 = new IOException("Could not delete incompletely written class file \"" + classFileResourceName + "\"");
                ioe2.initCause(ioe);
                throw ioe2;
            }
            throw ioe;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public void setIClassLoader(IClassLoader iClassLoader) {
        this.iClassLoader = iClassLoader;
    }

    public void setClassFileFinder(@Nullable ResourceFinder classFileFinder) {
        this.classFileFinder = classFileFinder;
    }

    public void setClassFileCreator(@Nullable ResourceCreator classFileCreator) {
        this.classFileCreator = classFileCreator;
    }

    public void setEncoding(@Nullable Charset encoding) {
        this.encoding = encoding;
    }

    public void setCharacterEncoding(@Nullable String characterEncoding) {
        this.setEncoding(Charset.forName(characterEncoding));
    }

    public void setDebugLines(boolean value) {
        this.debugLines = value;
    }

    public void setDebugVars(boolean value) {
        this.debugVars = value;
    }

    public void setDebugSource(boolean value) {
        this.debugSource = value;
    }

    public void setVerbose(boolean verbose) {
        this.benchmark = new Benchmark(verbose);
    }

    public void setSourceFinder(ResourceFinder sourceFinder) {
        this.sourceFinder = sourceFinder;
    }

    private class CompilerIClassLoader
    extends IClassLoader {
        private final ResourceFinder sourceFinder;
        @Nullable
        private final ResourceFinder classFileFinder;

        CompilerIClassLoader(@Nullable ResourceFinder sourceFinder, ResourceFinder classFileFinder, IClassLoader parentIClassLoader) {
            super(parentIClassLoader);
            this.sourceFinder = sourceFinder;
            this.classFileFinder = classFileFinder;
            super.postConstruct();
        }

        @Override
        @Nullable
        protected IClass findIClass(String type) throws ClassNotFoundException {
            Resource classFileResource;
            LOGGER.entering(null, "findIClass", type);
            String className = Descriptor.toClassName(type);
            LOGGER.log(Level.FINE, "className={0}", className);
            if (className.startsWith("java.")) {
                return null;
            }
            int idx = className.indexOf(36);
            String topLevelClassName = idx == -1 ? className : className.substring(0, idx);
            for (int i = 0; i < Compiler.this.parsedCompilationUnits.size(); ++i) {
                UnitCompiler uc = (UnitCompiler)Compiler.this.parsedCompilationUnits.get(i);
                IClass res = uc.findClass(topLevelClassName);
                if (res == null) continue;
                if (!className.equals(topLevelClassName) && (res = uc.findClass(className)) == null) {
                    return null;
                }
                this.defineIClass(res);
                return res;
            }
            Resource sourceResource = this.sourceFinder.findResource(ClassFile.getSourceResourceName(className));
            if (sourceResource == null) {
                return null;
            }
            ResourceFinder cff = this.classFileFinder;
            if (cff != ICompiler.FIND_NEXT_TO_SOURCE_FILE) {
                assert (cff != null);
                classFileResource = cff.findResource(ClassFile.getClassFileResourceName(className));
            } else {
                if (!(sourceResource instanceof FileResource)) {
                    return null;
                }
                File classFile = new File(((FileResource)sourceResource).getFile().getParentFile(), ClassFile.getClassFileResourceName(className.substring(className.lastIndexOf(46) + 1)));
                FileResource fileResource = classFileResource = classFile.exists() ? new FileResource(classFile) : null;
            }
            if (classFileResource != null && sourceResource.lastModified() <= classFileResource.lastModified()) {
                return this.defineIClassFromClassFileResource(classFileResource);
            }
            return this.defineIClassFromSourceResource(sourceResource, className);
        }

        private IClass defineIClassFromSourceResource(Resource sourceResource, String className) throws ClassNotFoundException {
            UnitCompiler uc;
            try {
                Java.AbstractCompilationUnit acu = Compiler.this.parseAbstractCompilationUnit(sourceResource.getFileName(), new BufferedInputStream(sourceResource.open()), Compiler.this.encoding);
                uc = new UnitCompiler(acu, this).options(Compiler.this.options);
            }
            catch (IOException ex) {
                throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", ex);
            }
            catch (CompileException ex) {
                throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", ex);
            }
            Compiler.this.parsedCompilationUnits.add(uc);
            IClass res = uc.findClass(className);
            if (res == null) {
                throw new ClassNotFoundException("\"" + sourceResource + "\" does not declare \"" + className + "\"");
            }
            this.defineIClass(res);
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IClass defineIClassFromClassFileResource(Resource classFileResource) throws ClassNotFoundException {
            Compiler.this.benchmark.beginReporting("Loading class file \"" + classFileResource.getFileName() + "\"");
            try {
                ClassFile cf;
                InputStream is = null;
                try {
                    is = classFileResource.open();
                    cf = new ClassFile(new BufferedInputStream(is));
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException("Opening class file resource \"" + classFileResource + "\"", ex);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
                }
                ClassFileIClass result = new ClassFileIClass(cf, this);
                this.defineIClass(result);
                result.resolveAllClasses();
                ClassFileIClass classFileIClass = result;
                return classFileIClass;
            }
            finally {
                Compiler.this.benchmark.endReporting();
            }
        }
    }
}

