/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.util.Collection;
import java.util.function.BiPredicate;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.GremlinTypeErrorException;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.structure.Element;

public enum Contains implements BiPredicate<Object, Collection>
{
    within{

        @Override
        public boolean test(Object first, Collection second) {
            if (first instanceof Element && second instanceof BulkSet && first.getClass() == ((BulkSet)second).getAllContainedElementsClass()) {
                return second.contains(first);
            }
            GremlinTypeErrorException typeError = null;
            for (Object o : second) {
                try {
                    if (!Compare.eq.test(first, o)) continue;
                    return true;
                }
                catch (GremlinTypeErrorException ex) {
                    typeError = ex;
                }
            }
            if (typeError != null) {
                throw typeError;
            }
            return false;
        }
    }
    ,
    without{

        @Override
        public boolean test(Object first, Collection second) {
            return !within.test(first, second);
        }
    };


    @Override
    public abstract boolean test(Object var1, Collection var2);

    public Contains negate() {
        return this.equals(within) ? without : within;
    }
}

