/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Configuring;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.DummyTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.service.Service;
import org.apache.tinkerpop.gremlin.structure.service.ServiceRegistry;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class CallStep<S, E>
extends AbstractStep<S, E>
implements TraversalParent,
AutoCloseable,
Configuring {
    private final boolean isStart;
    private boolean first = true;
    private Service.ServiceCallContext ctx;
    private String serviceName;
    private Service<S, E> service;
    private Map staticParams;
    private Traversal.Admin<S, Map> mapTraversal;
    private Parameters parameters;
    private transient Traverser.Admin<S> head = null;
    private transient CloseableIterator iterator = CloseableIterator.EmptyCloseableIterator.instance();

    public CallStep(Traversal.Admin traversal, boolean isStart) {
        this(traversal, isStart, null);
    }

    public CallStep(Traversal.Admin traversal, boolean isStart, String service) {
        this(traversal, isStart, service, null);
    }

    public CallStep(Traversal.Admin traversal, boolean isStart, String service, Map staticParams) {
        this(traversal, isStart, service, staticParams, null);
    }

    public CallStep(Traversal.Admin traversal, boolean isStart, String service, Map staticParams, Traversal.Admin<S, Map> mapTraversal) {
        super(traversal);
        this.isStart = isStart;
        this.serviceName = service;
        this.staticParams = staticParams == null ? new LinkedHashMap() : staticParams;
        this.mapTraversal = mapTraversal == null ? null : this.integrateChild(mapTraversal);
        this.parameters = new Parameters();
        this.ctx = new Service.ServiceCallContext(traversal, this);
    }

    protected Service<S, E> service() {
        return this.service != null ? this.service : (this.service = this.getServiceRegistry().get(this.serviceName, this.isStart, this.staticParams));
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    protected Traverser.Admin<E> processNextStart() {
        if (this.isStart && this.first) {
            this.first = false;
            if (this.starts.hasNext()) {
                throw new IllegalStateException("This service must be called without input: " + this.serviceName);
            }
            this.iterator = this.start();
        }
        while (true) {
            if (this.iterator.hasNext()) {
                Object next = this.iterator.next();
                if (next instanceof Traverser.Admin) {
                    return (Traverser.Admin)next;
                }
                if (this.head != null) {
                    return this.head.split(next, this);
                }
                return this.traversal.getTraverserGenerator().generate(next, this, 1L);
            }
            this.closeIterator();
            if (!this.starts.hasNext()) {
                throw FastNoSuchElementException.instance();
            }
            if (this.service().isBarrier()) {
                TraverserSet traverserSet = this.traversal.getTraverserSetSupplier().get();
                int maxBarrierSize = this.service().getMaxBarrierSize();
                if (maxBarrierSize == Integer.MAX_VALUE) {
                    this.starts.forEachRemaining(traverserSet::add);
                } else {
                    while (this.starts.hasNext() && traverserSet.size() < maxBarrierSize) {
                        traverserSet.add(this.starts.next());
                    }
                }
                this.iterator = this.flatMap(traverserSet);
                continue;
            }
            this.head = this.starts.next();
            this.iterator = this.flatMap(this.head);
        }
    }

    @Override
    public void close() {
        this.closeIterator();
        if (this.service != null) {
            this.service.close();
        }
        this.service = null;
    }

    protected void closeIterator() {
        CloseableIterator.closeIterator(this.iterator);
        this.iterator = CloseableIterator.EmptyCloseableIterator.instance();
    }

    public Map getMergedParams() {
        if (this.mapTraversal == null && this.parameters.isEmpty()) {
            return Collections.unmodifiableMap(this.staticParams);
        }
        return this.getMergedParams(new DummyTraverser(this.traversal.getTraverserGenerator()));
    }

    protected Map getMergedParams(Traverser.Admin<S> traverser) {
        if (this.mapTraversal == null && this.parameters.isEmpty()) {
            return Collections.unmodifiableMap(this.staticParams);
        }
        LinkedHashMap<Object, Object> params = new LinkedHashMap<Object, Object>(this.staticParams);
        if (this.mapTraversal != null) {
            params.putAll(TraversalUtil.apply(traverser, this.mapTraversal));
        }
        Object[] kvs = this.parameters.getKeyValues(traverser, new Object[0]);
        for (int i = 0; i < kvs.length; i += 2) {
            params.put(kvs[i], kvs[i + 1]);
        }
        return params;
    }

    protected Map getMergedParams(TraverserSet<S> traverserSet) {
        if (this.mapTraversal == null && this.parameters.isEmpty()) {
            return Collections.unmodifiableMap(this.staticParams);
        }
        HashSet<Map> paramsSet = new HashSet<Map>();
        for (Traverser.Admin<S> traverser : traverserSet) {
            paramsSet.add(this.getMergedParams(traverser));
        }
        if (paramsSet.size() > 1) {
            throw new UnsupportedOperationException("Cannot use multiple dynamic parameter sets with a barrier service call.");
        }
        return (Map)paramsSet.iterator().next();
    }

    protected CloseableIterator start() {
        Map params = this.getMergedParams();
        return this.service().execute(this.ctx, params);
    }

    protected CloseableIterator flatMap(Traverser.Admin<S> traverser) {
        Map params = this.getMergedParams(traverser);
        return this.service().execute(this.ctx, traverser, params);
    }

    protected CloseableIterator flatMap(TraverserSet<S> traverserSet) {
        Map params = this.getMergedParams(traverserSet);
        return this.service().execute(this.ctx, traverserSet, params);
    }

    protected ServiceRegistry getServiceRegistry() {
        Graph graph = this.traversal.getGraph().get();
        return graph.getServiceRegistry();
    }

    @Override
    public void reset() {
        super.reset();
        this.first = true;
        if (this.mapTraversal != null) {
            this.mapTraversal.reset();
        }
        this.parameters.getTraversals().forEach(Traversal.Admin::reset);
        this.closeIterator();
        this.head = null;
    }

    @Override
    public <S, E> List<Traversal.Admin<S, E>> getLocalChildren() {
        ArrayList children = new ArrayList();
        if (this.mapTraversal != null) {
            children.add(this.mapTraversal);
        }
        children.addAll(this.parameters.getTraversals());
        return children;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        if (this.mapTraversal != null) {
            this.integrateChild(this.mapTraversal);
        }
        this.parameters.getTraversals().forEach(this::integrateChild);
        this.ctx = new Service.ServiceCallContext(parentTraversal, this);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        Set<TraverserRequirement> requirements = this.getSelfAndChildRequirements(new TraverserRequirement[0]);
        requirements.addAll(this.service().getRequirements());
        return requirements;
    }

    @Override
    public String toString() {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.serviceName);
        if (!this.staticParams.isEmpty()) {
            args.add(this.staticParams);
        }
        if (this.mapTraversal != null) {
            args.add(this.mapTraversal);
        }
        if (!this.parameters.isEmpty()) {
            args.add(this.parameters);
        }
        return StringFactory.stepString(this, args.toArray());
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode() ^ Objects.hashCode(this.serviceName);
        if (!this.staticParams.isEmpty()) {
            hashCode ^= this.staticParams.hashCode();
        }
        if (this.mapTraversal != null) {
            hashCode ^= this.mapTraversal.hashCode();
        }
        if (!this.parameters.isEmpty()) {
            hashCode ^= this.parameters.hashCode();
        }
        return hashCode;
    }

    @Override
    public CallStep<S, E> clone() {
        CallStep clone = (CallStep)super.clone();
        clone.mapTraversal = this.mapTraversal != null ? this.mapTraversal.clone() : null;
        clone.parameters = this.parameters.clone();
        clone.ctx = new Service.ServiceCallContext(this.traversal, clone);
        clone.iterator = CloseableIterator.EmptyCloseableIterator.instance();
        clone.head = null;
        return clone;
    }

    @Override
    public void configure(Object ... keyValues) {
        this.parameters.set(this, keyValues);
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }
}

