/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.verification;

import java.util.Collections;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.Mutating;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ComputerVerificationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.VerificationException;

public final class ReadOnlyStrategy
extends AbstractTraversalStrategy<TraversalStrategy.VerificationStrategy>
implements TraversalStrategy.VerificationStrategy {
    private static final ReadOnlyStrategy INSTANCE = new ReadOnlyStrategy();

    private ReadOnlyStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        for (Step step : traversal.getSteps()) {
            if (!(step instanceof Mutating)) continue;
            throw new VerificationException("The provided traversal has a mutating step and thus is not read only: " + step, traversal);
        }
    }

    @Override
    public Set<Class<? extends TraversalStrategy.VerificationStrategy>> applyPost() {
        return Collections.singleton(ComputerVerificationStrategy.class);
    }

    public static ReadOnlyStrategy instance() {
        return INSTANCE;
    }
}

