/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.core.JsonToken;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;

final class JavaUtilSerializersV3d0 {
    private JavaUtilSerializersV3d0() {
    }

    static class ListJacksonDeserializer
    extends StdDeserializer<List> {
        protected ListJacksonDeserializer() {
            super(List.class);
        }

        public List deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            LinkedList<Object> s = new LinkedList<Object>();
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                s.add(deserializationContext.readValue(jsonParser, Object.class));
            }
            return s;
        }
    }

    static class SetJacksonDeserializer
    extends StdDeserializer<Set> {
        protected SetJacksonDeserializer() {
            super(Set.class);
        }

        public Set deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            LinkedHashSet<Object> s = new LinkedHashSet<Object>();
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                s.add(deserializationContext.readValue(jsonParser, Object.class));
            }
            return s;
        }
    }

    static class MapJacksonDeserializer
    extends StdDeserializer<Map> {
        protected MapJacksonDeserializer() {
            super(Map.class);
        }

        public Map deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            LinkedHashMap<Object, Object> m = new LinkedHashMap<Object, Object>();
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                Object key = deserializationContext.readValue(jsonParser, Object.class);
                jsonParser.nextToken();
                Object val = deserializationContext.readValue(jsonParser, Object.class);
                m.put(key, val);
            }
            return m;
        }
    }

    static final class ListJacksonSerializer
    extends StdSerializer<List> {
        public ListJacksonSerializer() {
            super(List.class);
        }

        public void serialize(List list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            for (Object o : list) {
                jsonGenerator.writeObject(o);
            }
        }

        public void serializeWithType(List list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            typeSerializer.writeTypePrefixForArray((Object)list, jsonGenerator);
            this.serialize(list, jsonGenerator, serializerProvider);
            typeSerializer.writeTypeSuffixForArray((Object)list, jsonGenerator);
        }
    }

    static final class SetJacksonSerializer
    extends StdSerializer<Set> {
        public SetJacksonSerializer() {
            super(Set.class);
        }

        public void serialize(Set set, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            for (Object o : set) {
                jsonGenerator.writeObject(o);
            }
        }

        public void serializeWithType(Set set, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            typeSerializer.writeTypePrefixForArray((Object)set, jsonGenerator);
            this.serialize(set, jsonGenerator, serializerProvider);
            typeSerializer.writeTypeSuffixForArray((Object)set, jsonGenerator);
        }
    }

    static final class MapEntryJacksonSerializer
    extends StdSerializer<Map.Entry> {
        public MapEntryJacksonSerializer() {
            super(Map.Entry.class);
        }

        public void serialize(Map.Entry entry, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            HashMap m = new HashMap();
            if (entry != null) {
                m.put(entry.getKey(), entry.getValue());
            }
            jsonGenerator.writeObject(m);
        }

        public void serializeWithType(Map.Entry entry, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            this.serialize(entry, jsonGenerator, serializerProvider);
        }
    }

    static final class MapJacksonSerializer
    extends StdSerializer<Map> {
        public MapJacksonSerializer() {
            super(Map.class);
        }

        public void serialize(Map map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            for (Map.Entry entry : map.entrySet()) {
                jsonGenerator.writeObject(entry.getKey());
                jsonGenerator.writeObject(entry.getValue());
            }
        }

        public void serializeWithType(Map map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            typeSerializer.writeTypePrefixForObject((Object)map, jsonGenerator);
            this.serialize(map, jsonGenerator, serializerProvider);
            typeSerializer.writeTypeSuffixForObject((Object)map, jsonGenerator);
        }
    }
}

