/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.gryo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import org.apache.tinkerpop.gremlin.process.remote.traversal.DefaultRemoteTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Text;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversalMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.InputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.OutputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.SerializerShim;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedProperty;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;
import org.apache.tinkerpop.gremlin.util.function.Lambda;

public final class GryoSerializersV3d0 {
    private static void writeElementProperties(KryoShim kryo, OutputShim output, Element element) {
        Iterator properties = element.properties(new String[0]);
        output.writeBoolean(properties.hasNext());
        while (properties.hasNext()) {
            Property p = properties.next();
            output.writeString(p.key());
            kryo.writeClassAndObject(output, p.value());
            output.writeBoolean(properties.hasNext());
        }
    }

    public static final class MetricsSerializer
    implements SerializerShim<Metrics> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Metrics object) {
            output.writeString(object.getId());
            output.writeString(object.getName());
            output.writeDouble((double)object.getDuration(TimeUnit.NANOSECONDS) / 1000000.0);
            kryo.writeObject(output, object.getCounts());
            LinkedHashMap annotations = new LinkedHashMap();
            object.getAnnotations().forEach(annotations::put);
            kryo.writeObject(output, annotations);
            ArrayList<? extends Metrics> nested = new ArrayList<Metrics>(object.getNested());
            kryo.writeObject(output, nested);
        }

        @Override
        public <I extends InputShim> Metrics read(KryoShim<I, ?> kryo, I input, Class<Metrics> clazz) {
            MutableMetrics m = new MutableMetrics(input.readString(), input.readString());
            m.setDuration(Math.round(input.readDouble() * 1000000.0), TimeUnit.NANOSECONDS);
            Map counts = kryo.readObject(input, HashMap.class);
            for (Map.Entry entry : counts.entrySet()) {
                m.setCount((String)entry.getKey(), (Long)entry.getValue());
            }
            Map annotations = kryo.readObject(input, HashMap.class);
            for (Map.Entry entry : annotations.entrySet()) {
                m.setAnnotation((String)entry.getKey(), entry.getValue());
            }
            List list = kryo.readObject(input, ArrayList.class);
            for (MutableMetrics nested : list) {
                m.addNested(nested);
            }
            return m;
        }
    }

    public static final class TraversalMetricsSerializer
    implements SerializerShim<TraversalMetrics> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, TraversalMetrics object) {
            output.writeDouble((double)object.getDuration(TimeUnit.NANOSECONDS) / 1000000.0);
            Collection<? extends Metrics> metrics = object.getMetrics();
            output.writeInt(metrics.size());
            metrics.forEach(m -> kryo.writeObject(output, m));
        }

        @Override
        public <I extends InputShim> TraversalMetrics read(KryoShim<I, ?> kryo, I input, Class<TraversalMetrics> clazz) {
            double duration = input.readDouble();
            int size = input.readInt();
            ArrayList<MutableMetrics> orderedMetrics = new ArrayList<MutableMetrics>();
            for (int ix = 0; ix < size; ++ix) {
                orderedMetrics.add(kryo.readObject(input, MutableMetrics.class));
            }
            return new DefaultTraversalMetrics(Math.round(duration * 1000000.0), orderedMetrics);
        }
    }

    public static final class DefaultRemoteTraverserSerializer
    implements SerializerShim<DefaultRemoteTraverser> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, DefaultRemoteTraverser remoteTraverser) {
            kryo.writeClassAndObject(output, remoteTraverser.get());
            output.writeLong(remoteTraverser.bulk());
        }

        @Override
        public <I extends InputShim> DefaultRemoteTraverser read(KryoShim<I, ?> kryo, I input, Class<DefaultRemoteTraverser> remoteTraverserClass) {
            Object o = kryo.readClassAndObject(input);
            return new DefaultRemoteTraverser<Object>(o, input.readLong());
        }
    }

    public static final class BindingSerializer
    implements SerializerShim<Bytecode.Binding> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Bytecode.Binding binding) {
            output.writeString(binding.variable());
            kryo.writeClassAndObject(output, binding.value());
        }

        @Override
        public <I extends InputShim> Bytecode.Binding read(KryoShim<I, ?> kryo, I input, Class<Bytecode.Binding> clazz) {
            String var = input.readString();
            Object val = kryo.readClassAndObject(input);
            return new Bytecode.Binding<Object>(var, val);
        }
    }

    public static final class LambdaSerializer
    implements SerializerShim<Lambda> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Lambda lambda) {
            output.writeString(lambda.getLambdaScript());
            output.writeString(lambda.getLambdaLanguage());
            output.writeInt(lambda.getLambdaArguments());
        }

        @Override
        public <I extends InputShim> Lambda read(KryoShim<I, ?> kryo, I input, Class<Lambda> clazz) {
            String script = input.readString();
            String language = input.readString();
            int arguments = input.readInt();
            if (-1 == arguments || arguments > 2) {
                return new Lambda.UnknownArgLambda(script, language, arguments);
            }
            if (0 == arguments) {
                return new Lambda.ZeroArgLambda(script, language);
            }
            if (1 == arguments) {
                return new Lambda.OneArgLambda(script, language);
            }
            return new Lambda.TwoArgLambda(script, language);
        }
    }

    public static final class TextPSerializer
    implements SerializerShim<TextP> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, TextP p) {
            BiPredicate tp = p.getBiPredicate();
            if (tp instanceof Text) {
                output.writeString(((Text)tp).name());
            } else if (tp instanceof Text.RegexPredicate) {
                output.writeString(((Text.RegexPredicate)tp).isNegate() ? "notRegex" : "regex");
            } else {
                output.writeString(tp.toString());
            }
            kryo.writeObject(output, p.getValue());
        }

        @Override
        public <I extends InputShim> TextP read(KryoShim<I, ?> kryo, I input, Class<TextP> clazz) {
            String predicate = input.readString();
            String value = kryo.readObject(input, String.class);
            try {
                return (TextP)TextP.class.getMethod(predicate, String.class).invoke(null, value);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    public static final class PSerializer
    implements SerializerShim<P> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, P p) {
            output.writeString(p instanceof ConnectiveP ? (p instanceof AndP ? "and" : "or") : p.getBiPredicate().toString());
            if (p instanceof ConnectiveP || p.getValue() instanceof Collection) {
                output.writeByte((byte)0);
                Collection<P<Object>> coll = p instanceof ConnectiveP ? ((ConnectiveP)p).getPredicates() : (Collection)p.getValue();
                output.writeInt(coll.size());
                coll.forEach(v -> kryo.writeClassAndObject(output, v));
            } else {
                output.writeByte((byte)1);
                kryo.writeClassAndObject(output, p.getValue());
            }
        }

        @Override
        public <I extends InputShim> P read(KryoShim<I, ?> kryo, I input, Class<P> clazz) {
            Object value;
            boolean isCollection;
            String predicate = input.readString();
            boolean bl = isCollection = input.readByte() == 0;
            if (isCollection) {
                value = new ArrayList();
                int size = input.readInt();
                for (int ix = 0; ix < size; ++ix) {
                    ((List)value).add(kryo.readClassAndObject(input));
                }
            } else {
                value = kryo.readClassAndObject(input);
            }
            try {
                if (predicate.equals("and") || predicate.equals("or")) {
                    return predicate.equals("and") ? new AndP((List)value) : new OrP((List)value);
                }
                if (value instanceof Collection) {
                    if (predicate.equals("between")) {
                        return P.between(((List)value).get(0), ((List)value).get(1));
                    }
                    if (predicate.equals("inside")) {
                        return P.inside(((List)value).get(0), ((List)value).get(1));
                    }
                    if (predicate.equals("outside")) {
                        return P.outside(((List)value).get(0), ((List)value).get(1));
                    }
                    if (predicate.equals("within")) {
                        return P.within((Collection)value);
                    }
                    if (predicate.equals("without")) {
                        return P.without((Collection)value);
                    }
                    return (P)P.class.getMethod(predicate, Collection.class).invoke(null, (Collection)value);
                }
                return (P)P.class.getMethod(predicate, Object.class).invoke(null, value);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    public static final class BytecodeSerializer
    implements SerializerShim<Bytecode> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Bytecode bytecode) {
            BytecodeSerializer.writeInstructions(kryo, output, bytecode.getSourceInstructions());
            BytecodeSerializer.writeInstructions(kryo, output, bytecode.getStepInstructions());
        }

        @Override
        public <I extends InputShim> Bytecode read(KryoShim<I, ?> kryo, I input, Class<Bytecode> clazz) {
            Bytecode bytecode = new Bytecode();
            int sourceInstructionCount = input.readInt();
            for (int ix = 0; ix < sourceInstructionCount; ++ix) {
                String operator = input.readString();
                Object[] args = operator.equals("withoutStrategies") ? (Object[])kryo.readObject(input, Class[].class) : kryo.readObject(input, Object[].class);
                bytecode.addSource(operator, args);
            }
            int stepInstructionCount = input.readInt();
            for (int ix = 0; ix < stepInstructionCount; ++ix) {
                String operator = input.readString();
                Object[] args = kryo.readObject(input, Object[].class);
                bytecode.addStep(operator, args);
            }
            return bytecode;
        }

        private static <O extends OutputShim> void writeInstructions(KryoShim<?, O> kryo, O output, List<Bytecode.Instruction> instructions) {
            output.writeInt(instructions.size());
            for (Bytecode.Instruction inst : instructions) {
                output.writeString(inst.getOperator());
                kryo.writeObject(output, inst.getArguments());
            }
        }
    }

    public static final class PathSerializer
    implements SerializerShim<Path> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Path path) {
            kryo.writeClassAndObject(output, DetachedFactory.detach(path, false));
        }

        @Override
        public <I extends InputShim> Path read(KryoShim<I, ?> kryo, I input, Class<Path> pathClass) {
            return (Path)kryo.readClassAndObject(input);
        }
    }

    public static final class VertexPropertySerializer
    implements SerializerShim<VertexProperty> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, VertexProperty vertexProperty) {
            kryo.writeClassAndObject(output, vertexProperty.id());
            output.writeString(vertexProperty.label());
            kryo.writeClassAndObject(output, vertexProperty.value());
            kryo.writeClassAndObject(output, vertexProperty.element().id());
            output.writeString(vertexProperty.element().label());
            if (vertexProperty instanceof DetachedVertexProperty || vertexProperty.graph().features().vertex().supportsMetaProperties()) {
                GryoSerializersV3d0.writeElementProperties(kryo, output, vertexProperty);
            } else {
                output.writeBoolean(false);
            }
        }

        @Override
        public <I extends InputShim> VertexProperty read(KryoShim<I, ?> kryo, I input, Class<VertexProperty> vertexPropertyClass) {
            DetachedVertexProperty.Builder vpBuilder = DetachedVertexProperty.build();
            vpBuilder.setId(kryo.readClassAndObject(input));
            vpBuilder.setLabel(input.readString());
            vpBuilder.setValue(kryo.readClassAndObject(input));
            DetachedVertex.Builder host = DetachedVertex.build();
            host.setId(kryo.readClassAndObject(input));
            host.setLabel(input.readString());
            vpBuilder.setV(host.create());
            while (input.readBoolean()) {
                vpBuilder.addProperty(new DetachedProperty<Object>(input.readString(), kryo.readClassAndObject(input)));
            }
            return vpBuilder.create();
        }
    }

    public static final class PropertySerializer
    implements SerializerShim<Property> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Property property) {
            output.writeString(property.key());
            kryo.writeClassAndObject(output, property.value());
            kryo.writeClassAndObject(output, property.element().id());
            output.writeString(property.element().label());
        }

        @Override
        public <I extends InputShim> Property read(KryoShim<I, ?> kryo, I input, Class<Property> propertyClass) {
            return new DetachedProperty<Object>(input.readString(), kryo.readClassAndObject(input), DetachedVertex.build().setId(kryo.readClassAndObject(input)).setLabel(input.readString()).create());
        }
    }

    public static final class VertexSerializer
    implements SerializerShim<Vertex> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Vertex vertex) {
            kryo.writeClassAndObject(output, vertex.id());
            output.writeString(vertex.label());
            Iterator properties = vertex.properties(new String[0]);
            output.writeBoolean(properties.hasNext());
            while (properties.hasNext()) {
                VertexProperty vp = properties.next();
                kryo.writeClassAndObject(output, vp.id());
                output.writeString(vp.label());
                kryo.writeClassAndObject(output, vp.value());
                if (vp instanceof DetachedVertexProperty || vertex.graph().features().vertex().supportsMetaProperties()) {
                    GryoSerializersV3d0.writeElementProperties(kryo, output, vp);
                } else {
                    output.writeBoolean(false);
                }
                output.writeBoolean(properties.hasNext());
            }
        }

        @Override
        public <I extends InputShim> Vertex read(KryoShim<I, ?> kryo, I input, Class<Vertex> vertexClass) {
            DetachedVertex.Builder builder = DetachedVertex.build();
            builder.setId(kryo.readClassAndObject(input));
            builder.setLabel(input.readString());
            while (input.readBoolean()) {
                DetachedVertexProperty.Builder vpBuilder = DetachedVertexProperty.build();
                vpBuilder.setId(kryo.readClassAndObject(input));
                vpBuilder.setLabel(input.readString());
                vpBuilder.setValue(kryo.readClassAndObject(input));
                while (input.readBoolean()) {
                    vpBuilder.addProperty(new DetachedProperty<Object>(input.readString(), kryo.readClassAndObject(input)));
                }
                builder.addProperty(vpBuilder.create());
            }
            return builder.create();
        }
    }

    public static final class EdgeSerializer
    implements SerializerShim<Edge> {
        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Edge edge) {
            kryo.writeClassAndObject(output, edge.id());
            output.writeString(edge.label());
            kryo.writeClassAndObject(output, edge.inVertex().id());
            try {
                output.writeString(edge.inVertex().label());
            }
            catch (Exception ex) {
                output.writeString("vertex");
            }
            kryo.writeClassAndObject(output, edge.outVertex().id());
            try {
                output.writeString(edge.outVertex().label());
            }
            catch (Exception ex) {
                output.writeString("vertex");
            }
            GryoSerializersV3d0.writeElementProperties(kryo, output, edge);
        }

        @Override
        public <I extends InputShim> Edge read(KryoShim<I, ?> kryo, I input, Class<Edge> edgeClass) {
            DetachedEdge.Builder builder = DetachedEdge.build();
            builder.setId(kryo.readClassAndObject(input));
            builder.setLabel(input.readString());
            DetachedVertex.Builder inV = DetachedVertex.build();
            inV.setId(kryo.readClassAndObject(input));
            inV.setLabel(input.readString());
            builder.setInV(inV.create());
            DetachedVertex.Builder outV = DetachedVertex.build();
            outV.setId(kryo.readClassAndObject(input));
            outV.setLabel(input.readString());
            builder.setOutV(outV.create());
            while (input.readBoolean()) {
                builder.addProperty(new DetachedProperty<Object>(input.readString(), kryo.readClassAndObject(input)));
            }
            return builder.create();
        }
    }
}

