/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import javax.naming.InitialContext;
import org.apache.tinkerpop.gremlin.util.Gremlin;

public class UserAgent {
    public static final String USER_AGENT_HEADER_NAME = "User-Agent";
    public static final String USER_AGENT;

    private static String getAttributeOrDefault(ThrowingSupplier<String> supplier) {
        String ret = "NotAvailable";
        try {
            ret = supplier.get().replace(' ', '_');
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    static {
        String applicationName = UserAgent.getAttributeOrDefault(() -> (String)new InitialContext().lookup("java:app/AppName"));
        String glvVersion = UserAgent.getAttributeOrDefault(() -> Gremlin.version());
        if (glvVersion.equals("VersionNotFound")) {
            glvVersion = "NotAvailable";
        }
        String javaVersion = UserAgent.getAttributeOrDefault(() -> System.getProperty("java.version", "NotAvailable"));
        String osName = UserAgent.getAttributeOrDefault(() -> System.getProperty("os.name", "NotAvailable"));
        String osVersion = UserAgent.getAttributeOrDefault(() -> System.getProperty("os.version", "NotAvailable"));
        String cpuArch = UserAgent.getAttributeOrDefault(() -> System.getProperty("os.arch", "NotAvailable"));
        USER_AGENT = String.format("%s Gremlin-Java.%s %s %s.%s %s", applicationName, glvVersion, javaVersion, osName, osVersion, cpuArch);
    }

    @FunctionalInterface
    private static interface ThrowingSupplier<T> {
        public T get() throws Exception;
    }
}

