/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.kryo.pool;

import java.util.Queue;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.pool.KryoCallback;
import org.apache.tinkerpop.shaded.kryo.pool.KryoFactory;
import org.apache.tinkerpop.shaded.kryo.pool.KryoPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KryoPoolQueueImpl
implements KryoPool {
    private final Queue<Kryo> queue;
    private final KryoFactory factory;

    KryoPoolQueueImpl(KryoFactory factory, Queue<Kryo> queue) {
        this.factory = factory;
        this.queue = queue;
    }

    public int size() {
        return this.queue.size();
    }

    @Override
    public Kryo borrow() {
        Kryo res = this.queue.poll();
        if (res != null) {
            return res;
        }
        return this.factory.create();
    }

    @Override
    public void release(Kryo kryo) {
        this.queue.offer(kryo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(KryoCallback<T> callback) {
        Kryo kryo = this.borrow();
        try {
            T t = callback.execute(kryo);
            return t;
        }
        finally {
            this.release(kryo);
        }
    }

    public void clear() {
        this.queue.clear();
    }
}

