/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.util.AbstractTransaction;

public abstract class AbstractThreadedTransaction
extends AbstractTransaction {
    protected final List<Consumer<Transaction.Status>> transactionListeners = new CopyOnWriteArrayList<Consumer<Transaction.Status>>();

    public AbstractThreadedTransaction(Graph g) {
        super(g);
    }

    @Override
    protected void fireOnCommit() {
        this.transactionListeners.forEach(c -> c.accept(Transaction.Status.COMMIT));
    }

    @Override
    protected void fireOnRollback() {
        this.transactionListeners.forEach(c -> c.accept(Transaction.Status.ROLLBACK));
    }

    @Override
    public void addTransactionListener(Consumer<Transaction.Status> listener) {
        this.transactionListeners.add(listener);
    }

    @Override
    public void removeTransactionListener(Consumer<Transaction.Status> listener) {
        this.transactionListeners.remove(listener);
    }

    @Override
    public void clearTransactionListeners() {
        this.transactionListeners.clear();
    }

    @Override
    protected void doReadWrite() {
    }

    @Override
    protected void doClose() {
        this.clearTransactionListeners();
    }

    @Override
    public synchronized Transaction onReadWrite(Consumer<Transaction> consumer) {
        throw new UnsupportedOperationException("Threaded transactions are open when created and in manual mode");
    }

    @Override
    public synchronized Transaction onClose(Consumer<Transaction> consumer) {
        throw new UnsupportedOperationException("Threaded transactions are open when created and in manual mode");
    }
}

