/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.empty;

import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.configuration2.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactoryClass;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

@GraphFactoryClass(value=EmptyGraphFactory.class)
public final class EmptyGraph
implements Graph {
    private static final String MESSAGE = "The graph is immutable and empty";
    private static final EmptyGraph INSTANCE = new EmptyGraph();
    private final EmptyGraphFeatures features = new EmptyGraphFeatures();

    private EmptyGraph() {
    }

    public static Graph instance() {
        return INSTANCE;
    }

    @Override
    public Graph.Features features() {
        return this.features;
    }

    @Override
    public Vertex addVertex(Object ... keyValues) {
        throw Graph.Exceptions.vertexAdditionsNotSupported();
    }

    @Override
    public <C extends GraphComputer> C compute(Class<C> graphComputerClass) {
        throw Graph.Exceptions.graphComputerNotSupported();
    }

    @Override
    public GraphComputer compute() {
        throw Graph.Exceptions.graphComputerNotSupported();
    }

    @Override
    public Transaction tx() {
        throw Graph.Exceptions.transactionsNotSupported();
    }

    @Override
    public Graph.Variables variables() {
        throw Graph.Exceptions.variablesNotSupported();
    }

    @Override
    public Configuration configuration() {
        throw new IllegalStateException(MESSAGE);
    }

    @Override
    public void close() throws Exception {
        throw new IllegalStateException(MESSAGE);
    }

    @Override
    public Iterator<Vertex> vertices(Object ... vertexIds) {
        return Collections.emptyIterator();
    }

    @Override
    public Iterator<Edge> edges(Object ... edgeIds) {
        return Collections.emptyIterator();
    }

    public String toString() {
        return StringFactory.graphString(this, "empty");
    }

    public static final class EmptyGraphFactory {
        public static Graph open(Configuration conf) {
            return EmptyGraph.instance();
        }
    }

    public static final class EmptyGraphFeatures
    implements Graph.Features {
        private Graph.Features.GraphFeatures graphFeatures = new EmptyGraphGraphFeatures();
        private Graph.Features.VertexFeatures vertexFeatures = new EmptyGraphVertexFeatures();
        private Graph.Features.EdgeFeatures edgeFeatures = new EmptyGraphEdgeFeatures();
        private Graph.Features.EdgePropertyFeatures edgePropertyFeatures = new EmptyGraphEdgePropertyFeatures();
        private Graph.Features.VertexPropertyFeatures vertexPropertyFeatures = new EmptyGraphVertexPropertyFeatures();

        private EmptyGraphFeatures() {
        }

        @Override
        public Graph.Features.GraphFeatures graph() {
            return this.graphFeatures;
        }

        @Override
        public Graph.Features.VertexFeatures vertex() {
            return this.vertexFeatures;
        }

        @Override
        public Graph.Features.EdgeFeatures edge() {
            return this.edgeFeatures;
        }

        public abstract class EmptyGraphElementFeatures
        implements Graph.Features.ElementFeatures {
            @Override
            public boolean supportsAddProperty() {
                return false;
            }

            @Override
            public boolean supportsRemoveProperty() {
                return false;
            }
        }

        public final class EmptyGraphEdgePropertyFeatures
        implements Graph.Features.EdgePropertyFeatures {
        }

        public final class EmptyGraphVertexPropertyFeatures
        implements Graph.Features.VertexPropertyFeatures {
            @Override
            public boolean supportsRemoveProperty() {
                return false;
            }
        }

        public final class EmptyGraphEdgeFeatures
        extends EmptyGraphElementFeatures
        implements Graph.Features.EdgeFeatures {
            @Override
            public boolean supportsAddEdges() {
                return false;
            }

            @Override
            public boolean supportsRemoveEdges() {
                return false;
            }

            @Override
            public Graph.Features.EdgePropertyFeatures properties() {
                return EmptyGraphFeatures.this.edgePropertyFeatures;
            }
        }

        public final class EmptyGraphVertexFeatures
        extends EmptyGraphElementFeatures
        implements Graph.Features.VertexFeatures {
            @Override
            public VertexProperty.Cardinality getCardinality(String key) {
                return VertexProperty.Cardinality.list;
            }

            @Override
            public boolean supportsAddVertices() {
                return false;
            }

            @Override
            public boolean supportsRemoveVertices() {
                return false;
            }

            @Override
            public Graph.Features.VertexPropertyFeatures properties() {
                return EmptyGraphFeatures.this.vertexPropertyFeatures;
            }
        }

        public final class EmptyGraphGraphFeatures
        implements Graph.Features.GraphFeatures {
            @Override
            public boolean supportsPersistence() {
                return false;
            }

            @Override
            public boolean supportsTransactions() {
                return false;
            }

            @Override
            public boolean supportsThreadedTransactions() {
                return false;
            }

            @Override
            public Graph.Features.VariableFeatures variables() {
                return null;
            }

            @Override
            public boolean supportsComputer() {
                return false;
            }
        }
    }
}

