/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.iterator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;

public final class MultiIterator<T>
implements Iterator<T>,
Serializable,
AutoCloseable {
    private final List<Iterator<T>> iterators = new ArrayList<Iterator<T>>();
    private int current = 0;

    public void addIterator(Iterator<T> iterator) {
        this.iterators.add(iterator);
    }

    @Override
    public boolean hasNext() {
        if (this.current >= this.iterators.size()) {
            return false;
        }
        Iterator<T> currentIterator = this.iterators.get(this.current);
        while (true) {
            if (currentIterator.hasNext()) {
                return true;
            }
            ++this.current;
            if (this.current >= this.iterators.size()) break;
            currentIterator = this.iterators.get(this.current);
        }
        return false;
    }

    @Override
    public void remove() {
        this.iterators.get(this.current).remove();
    }

    @Override
    public T next() {
        if (this.iterators.isEmpty()) {
            throw FastNoSuchElementException.instance();
        }
        Iterator<T> currentIterator = this.iterators.get(this.current);
        while (true) {
            if (currentIterator.hasNext()) {
                return currentIterator.next();
            }
            ++this.current;
            if (this.current >= this.iterators.size()) break;
            currentIterator = this.iterators.get(this.current);
        }
        throw FastNoSuchElementException.instance();
    }

    public void clear() {
        this.iterators.clear();
        this.current = 0;
    }

    @Override
    public void close() {
        for (Iterator<T> iterator : this.iterators) {
            CloseableIterator.closeIterator(iterator);
        }
    }
}

