/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.simple;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.tinkerpop.gremlin.driver.simple.SimpleClient;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;

public abstract class AbstractClient
implements SimpleClient {
    protected final CallbackResponseHandler callbackResponseHandler = new CallbackResponseHandler();
    protected final EventLoopGroup group;

    public AbstractClient(String threadPattern) {
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern(threadPattern).build();
        this.group = new NioEventLoopGroup(1, (ThreadFactory)threadFactory);
    }

    public abstract void writeAndFlush(RequestMessage var1) throws Exception;

    @Override
    public void submit(RequestMessage requestMessage, Consumer<ResponseMessage> callback) throws Exception {
        this.callbackResponseHandler.callbackByRequestId.put(requestMessage.getRequestId(), callback);
        this.writeAndFlush(requestMessage);
    }

    @Override
    public List<ResponseMessage> submit(RequestMessage requestMessage) throws Exception {
        return this.submitAsync(requestMessage).get(180L, TimeUnit.SECONDS);
    }

    @Override
    public CompletableFuture<List<ResponseMessage>> submitAsync(RequestMessage requestMessage) throws Exception {
        ArrayList results = new ArrayList();
        CompletableFuture<List<ResponseMessage>> f = new CompletableFuture<List<ResponseMessage>>();
        this.callbackResponseHandler.callbackByRequestId.put(requestMessage.getRequestId(), response -> {
            if (f.isDone()) {
                throw new RuntimeException("A terminating message was already encountered - no more messages should have been received");
            }
            results.add(response);
            if (response.getStatus().getCode().isFinalResponse()) {
                f.complete(results);
            }
        });
        this.writeAndFlush(requestMessage);
        return f;
    }

    static class CallbackResponseHandler
    extends SimpleChannelInboundHandler<ResponseMessage> {
        public Map<UUID, Consumer<ResponseMessage>> callbackByRequestId = new HashMap<UUID, Consumer<ResponseMessage>>();

        CallbackResponseHandler() {
        }

        protected void channelRead0(ChannelHandlerContext channelHandlerContext, ResponseMessage response) throws Exception {
            this.callbackByRequestId.get(response.getRequestId()).accept(response);
        }
    }
}

