/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.CompareType;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.GType;
import org.apache.tinkerpop.gremlin.process.traversal.NotP;
import org.apache.tinkerpop.gremlin.process.traversal.PBiPredicate;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;

public class P<V>
implements Predicate<V>,
Serializable,
Cloneable {
    protected PBiPredicate<V, V> biPredicate;
    protected Map<String, V> variables = new HashMap<String, V>();
    protected Collection<V> literals = Collections.EMPTY_LIST;
    private boolean isCollection = false;

    public P(PBiPredicate<V, V> biPredicate, V value) {
        this.setValue(value);
        this.biPredicate = biPredicate;
    }

    public P(PBiPredicate<V, V> biPredicate, GValue<V> value) {
        if (value != null) {
            if (value.isVariable()) {
                this.variables.put(value.getName(), value.get());
            } else {
                this.literals = Collections.singleton(value.get());
            }
        } else {
            this.literals = Collections.singleton(null);
        }
        this.isCollection = false;
        this.biPredicate = biPredicate;
    }

    protected P(PBiPredicate<V, V> biPredicate, Collection<V> literals, Map<String, V> variables, boolean isCollection) {
        this.biPredicate = biPredicate;
        this.variables.putAll(variables);
        this.literals = new ArrayList<V>(literals);
        this.isCollection = isCollection;
    }

    public PBiPredicate<V, V> getBiPredicate() {
        return this.biPredicate;
    }

    public String getPredicateName() {
        return this.biPredicate.getPredicateName();
    }

    public V getValue() {
        if (this.isCollection) {
            Collection values = this.literals.stream().collect(Collectors.toList());
            values.addAll(this.variables.values());
            return (V)values;
        }
        if (!this.literals.isEmpty()) {
            return this.literals.iterator().next();
        }
        if (!this.variables.isEmpty()) {
            return this.variables.values().iterator().next();
        }
        return null;
    }

    public void setValue(V value) {
        this.variables.clear();
        this.literals = Collections.EMPTY_LIST;
        if (value == null) {
            this.isCollection = false;
            this.literals = Collections.singleton(null);
        } else if (value instanceof GValue) {
            this.variables.put(((GValue)value).getName(), ((GValue)value).get());
            this.isCollection = false;
        } else if (value instanceof Collection) {
            this.isCollection = true;
            if (((Collection)value).stream().anyMatch(v -> v instanceof GValue)) {
                this.literals = new ArrayList<V>();
                for (Object v2 : (Collection)value) {
                    if (v2 instanceof GValue) {
                        if (((GValue)v2).isVariable()) {
                            this.variables.put(((GValue)v2).getName(), ((GValue)v2).get());
                            continue;
                        }
                        this.literals.add(((GValue)v2).get());
                        continue;
                    }
                    this.literals.add(v2);
                }
            } else {
                this.literals = (Collection)value;
            }
        } else {
            this.isCollection = false;
            this.literals = Collections.singleton(value);
        }
    }

    @Override
    public boolean test(V testValue) {
        return this.biPredicate.test(testValue, this.getValue());
    }

    public int hashCode() {
        int result = this.biPredicate.hashCode();
        if (null != this.variables) {
            result ^= this.variables.hashCode();
        }
        if (null != this.literals) {
            result ^= this.literals.hashCode();
        }
        return result;
    }

    public boolean equals(Object other) {
        return other instanceof P && ((P)other).getClass().equals(this.getClass()) && ((P)other).getBiPredicate().equals(this.biPredicate) && (((P)other).variables == null && this.variables == null || ((P)other).variables != null && ((P)other).variables.equals(this.variables)) && (((P)other).literals == null && this.literals == null || ((P)other).literals != null && CollectionUtils.isEqualCollection(((P)other).literals, this.literals));
    }

    public String toString() {
        return null == this.getValue() ? this.biPredicate.toString() : this.biPredicate.toString() + "(" + this.getValue() + ")";
    }

    @Override
    public P<V> negate() {
        return new NotP(this);
    }

    @Override
    public P<V> and(Predicate<? super V> predicate) {
        if (!(predicate instanceof P)) {
            throw new IllegalArgumentException("Only P predicates can be and'd together");
        }
        return new AndP(Arrays.asList(this, (P)predicate));
    }

    @Override
    public P<V> or(Predicate<? super V> predicate) {
        if (!(predicate instanceof P)) {
            throw new IllegalArgumentException("Only P predicates can be or'd together");
        }
        return new OrP(Arrays.asList(this, (P)predicate));
    }

    public P<V> clone() {
        try {
            return (P)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public boolean isParameterized() {
        return !this.variables.isEmpty();
    }

    public void updateVariable(String name, Object value) {
        if (this.variables.containsKey(name)) {
            this.variables.put(name, value);
        }
    }

    public Set<GValue<?>> getGValues() {
        HashSet results = new HashSet();
        for (Map.Entry<String, V> entry : this.variables.entrySet()) {
            results.add(GValue.of(entry.getKey(), entry.getValue()));
        }
        return results;
    }

    public static <V> P<V> eq(V value) {
        return new P<Object>(Compare.eq, value);
    }

    public static <V> P<V> eq(GValue<V> value) {
        return new P<Object>(Compare.eq, value);
    }

    public static <V> P<V> neq(V value) {
        return new P<Object>(Compare.neq, value);
    }

    public static <V> P<V> neq(GValue<V> value) {
        return new P<Object>(Compare.neq, value);
    }

    public static <V> P<V> lt(V value) {
        return new P<Object>(Compare.lt, value);
    }

    public static <V> P<V> lt(GValue<V> value) {
        return new P<Object>(Compare.lt, value);
    }

    public static <V> P<V> lte(V value) {
        return new P<Object>(Compare.lte, value);
    }

    public static <V> P<V> lte(GValue<V> value) {
        return new P<Object>(Compare.lte, value);
    }

    public static <V> P<V> gt(V value) {
        return new P<Object>(Compare.gt, value);
    }

    public static <V> P<V> gt(GValue<V> value) {
        return new P<Object>(Compare.gt, value);
    }

    public static <V> P<V> gte(V value) {
        return new P<Object>(Compare.gte, value);
    }

    public static <V> P<V> gte(GValue<V> value) {
        return new P<Object>(Compare.gte, value);
    }

    public static <V> P<V> inside(V first, V second) {
        return new AndP(Arrays.asList(new P<Object>(Compare.gt, first), new P<Object>(Compare.lt, second)));
    }

    public static <V> P<V> inside(GValue<V> first, GValue<V> second) {
        return new AndP(Arrays.asList(new P<Object>(Compare.gt, first), new P<Object>(Compare.lt, second)));
    }

    public static <V> P<V> outside(V first, V second) {
        return new OrP(Arrays.asList(new P<Object>(Compare.lt, first), new P<Object>(Compare.gt, second)));
    }

    public static <V> P<V> outside(GValue<V> first, GValue<V> second) {
        return new OrP(Arrays.asList(new P<Object>(Compare.lt, first), new P<Object>(Compare.gt, second)));
    }

    public static <V> P<V> between(V first, V second) {
        return new AndP(Arrays.asList(new P<Object>(Compare.gte, first), new P<Object>(Compare.lt, second)));
    }

    public static <V> P<V> between(GValue<V> first, GValue<V> second) {
        return new AndP(Arrays.asList(new P<Object>(Compare.gte, first), new P<Object>(Compare.lt, second)));
    }

    public static <V> P<V> within(V ... values) {
        Object[] objectArray;
        if (null == values) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = null;
        } else {
            objectArray = values;
        }
        V[] v = objectArray;
        return P.within(Arrays.asList(v));
    }

    public static <V> P<V> within(GValue<V> ... values) {
        Object[] objectArray;
        if (null == values) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = null;
        } else {
            objectArray = values;
        }
        Object[] v = objectArray;
        return P.within(Arrays.asList(v));
    }

    public static <V> P<V> within(Collection<V> value) {
        if (null == value) {
            return P.within(new Object[]{null});
        }
        return new P<Collection<V>>(Contains.within, value);
    }

    public static <V> P<V> without(V ... values) {
        Object[] objectArray;
        if (null == values) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = null;
        } else {
            objectArray = values;
        }
        V[] v = objectArray;
        return P.without(Arrays.asList(v));
    }

    public static <V> P<V> without(GValue<V> ... values) {
        Object[] objectArray;
        if (null == values) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = null;
        } else {
            objectArray = values;
        }
        Object[] v = objectArray;
        return P.without(Arrays.asList(v));
    }

    public static <V> P<V> without(Collection<V> value) {
        if (null == value) {
            return P.without(new Object[]{null});
        }
        return new P<Collection<V>>(Contains.without, value);
    }

    public static <V> P<V> typeOf(GType value) {
        return new P<GType>(CompareType.typeOf, value);
    }

    public static <V> P<V> typeOf(String value) {
        return new P<String>(CompareType.typeOf, value);
    }

    public static <V> P<V> typeOf(Class<?> value) {
        return new P(CompareType.typeOf, value);
    }

    public static P test(PBiPredicate biPredicate, Object value) {
        return new P<Object>(biPredicate, value);
    }

    public static <V> P<V> not(P<V> predicate) {
        return predicate.negate();
    }
}

