/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mail.search;

import jakarta.mail.Message;
import jakarta.mail.search.SearchTerm;
import java.util.Arrays;

public final class OrTerm
extends SearchTerm {
    private static final long serialVersionUID = 5380534067523646936L;
    private final SearchTerm[] terms;

    public OrTerm(SearchTerm a, SearchTerm b) {
        this.terms = new SearchTerm[]{a, b};
    }

    public OrTerm(SearchTerm[] terms) {
        this.terms = terms;
    }

    public SearchTerm[] getTerms() {
        return this.terms;
    }

    @Override
    public boolean match(Message message) {
        for (int i = 0; i < this.terms.length; ++i) {
            SearchTerm term = this.terms[i];
            if (!term.match(message)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OrTerm)) {
            return false;
        }
        return Arrays.equals(this.terms, ((OrTerm)other).terms);
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.terms.length; ++i) {
            hash = hash * 37 + this.terms[i].hashCode();
        }
        return hash;
    }
}

