/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.pem;

import io.churchkey.asn1.Asn1Type;
import io.churchkey.asn1.DerParser;
import io.churchkey.asn1.Oid;
import io.churchkey.pem.EcCurveParams;
import io.churchkey.util.Pem;
import io.churchkey.util.Utils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.spec.ECParameterSpec;

public class BeginEcParameters {
    private BeginEcParameters() {
    }

    public static byte[] encode(ECParameterSpec params) {
        return Pem.builder().type("EC PARAMETERS").data(EcCurveParams.encode(params)).format().getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] encode(Oid oid) {
        return null;
    }

    public static Object decode(byte[] bytes) throws IOException {
        if (!Utils.startsWith("-----BEGIN EC PARAMETERS-----", bytes)) {
            throw new IllegalArgumentException("Contents do not start with -----BEGIN EC PARAMETERS-----");
        }
        Pem pem = Pem.parse(bytes);
        byte[] data = pem.getData();
        Asn1Type type = new DerParser(data).readObject().getType();
        if (type == Asn1Type.SEQUENCE) {
            return EcCurveParams.parse(data);
        }
        if (type == Asn1Type.OBJECT_IDENTIFIER) {
            return EcCurveParams.parseOid(data);
        }
        throw new UnsupportedOperationException("Unexpected ASN1 type: " + (Object)((Object)type));
    }
}

