/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.persistence.jpa.domain;

import jakarta.batch.runtime.BatchStatus;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity;
import org.apache.batchee.container.services.persistence.jpa.domain.PropertyHelper;

@Entity
@NamedQueries(value={@NamedQuery(name="org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.mostRecent", query="SELECT e FROM JobExecutionEntity e WHERE e.instance.jobInstanceId = :instanceId ORDER BY e.createTime DESC"), @NamedQuery(name="org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.findByInstance", query="SELECT e FROM JobExecutionEntity e WHERE e.instance.jobInstanceId = :instanceId"), @NamedQuery(name="org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.deleteByInstanceId", query="delete from JobExecutionEntity e where e.instance.jobInstanceId = :instanceId"), @NamedQuery(name="org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.deleteByDate", query="delete from JobExecutionEntity e where e.endTime < :date"), @NamedQuery(name="org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.findRunning", query="SELECT e FROM JobExecutionEntity e WHERE e.batchStatus in :statuses and e.instance.name = :name")})
@Table(name="BATCH_JOBEXECUTION")
public class JobExecutionEntity {
    public static final String TABLE_NAME = "BATCH_JOBEXECUTION";
    @Id
    @GeneratedValue
    private long executionId;
    private Timestamp createTime;
    private Timestamp startTime;
    private Timestamp endTime;
    private Timestamp updateTime;
    @Enumerated(value=EnumType.STRING)
    private BatchStatus batchStatus;
    private String exitStatus;
    @Lob
    private String jobProperties;
    @ManyToOne
    private JobInstanceEntity instance;

    public long getExecutionId() {
        return this.executionId;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public Timestamp getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Timestamp updateTime) {
        this.updateTime = updateTime;
    }

    public BatchStatus getBatchStatus() {
        return this.batchStatus;
    }

    public void setBatchStatus(BatchStatus batchStatus) {
        this.batchStatus = batchStatus;
    }

    public String getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(String exitStatus) {
        this.exitStatus = exitStatus;
    }

    public Properties getJobProperties() {
        return PropertyHelper.stringToProperties(this.jobProperties);
    }

    public void setJobProperties(Properties jobProperties) {
        this.jobProperties = PropertyHelper.propertiesToString(jobProperties);
    }

    public JobInstanceEntity getInstance() {
        return this.instance;
    }

    public void setInstance(JobInstanceEntity instance) {
        this.instance = instance;
    }

    public static interface Queries {
        public static final String MOST_RECENT = "org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.mostRecent";
        public static final String FIND_BY_INSTANCE = "org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.findByInstance";
        public static final String FIND_RUNNING = "org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.findRunning";
        public static final String DELETE_BY_INSTANCE_ID = "org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.deleteByInstanceId";
        public static final String DELETE_BY_DATE = "org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.deleteByDate";
        public static final List<BatchStatus> RUNNING_STATUSES = Arrays.asList(BatchStatus.STARTED, BatchStatus.STARTING, BatchStatus.STOPPING);
    }
}

