/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.executor;

import jakarta.batch.operations.JobOperator;
import jakarta.batch.runtime.BatchRuntime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.container.util.BatchWorkUnit;
import org.apache.batchee.container.util.ClassLoaderAwareHandler;
import org.apache.batchee.spi.BatchThreadPoolService;

public abstract class AbstractThreadPoolService
implements BatchThreadPoolService {
    private static final Logger LOGGER = Logger.getLogger(AbstractThreadPoolService.class.getName());
    protected ExecutorService executorService;
    volatile boolean shutdown = false;
    private Set<BatchWorkUnit> runningBatchWorkUnits = Collections.synchronizedSet(new HashSet());

    protected abstract ExecutorService newExecutorService(Properties var1);

    @Override
    public void init(Properties batchConfig) throws BatchContainerServiceException {
        this.executorService = this.newExecutorService(batchConfig);
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
        this.shutdown = true;
        if (!this.runningBatchWorkUnits.isEmpty()) {
            JobOperator jobOperator = BatchRuntime.getJobOperator();
            for (BatchWorkUnit batchWorkUnit : this.runningBatchWorkUnits) {
                try {
                    long executionId = batchWorkUnit.getJobExecutionImpl().getExecutionId();
                    if (executionId < 0L) continue;
                    jobOperator.stop(executionId);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Failure while shutting down execution", e);
                }
            }
        }
        this.executorService.shutdownNow();
        this.executorService = null;
    }

    @Override
    public void executeTask(Runnable work, Object config) {
        if (this.shutdown) {
            throw new IllegalStateException("Refuse to start Batch Task due to shutdown being in progress!");
        }
        this.executorService.execute(ClassLoaderAwareHandler.runnableLoaderAware(new ActiveWorkTracker(work)));
    }

    public String toString() {
        return this.getClass().getName();
    }

    class ActiveWorkTracker
    implements Runnable {
        private final Runnable work;

        ActiveWorkTracker(Runnable work) {
            this.work = work;
        }

        @Override
        public void run() {
            try {
                if (this.work instanceof BatchWorkUnit) {
                    AbstractThreadPoolService.this.runningBatchWorkUnits.add((BatchWorkUnit)this.work);
                }
                this.work.run();
            }
            finally {
                if (this.work instanceof BatchWorkUnit) {
                    AbstractThreadPoolService.this.runningBatchWorkUnits.remove(this.work);
                }
            }
        }
    }
}

