/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.model.XmlField;
import org.apache.fulcrum.intake.validator.ShortValidator;

public class ShortField
extends Field<Short> {
    private static final long serialVersionUID = -5838127207028024370L;

    public ShortField(XmlField field, Group group) throws IntakeException {
        super(field, group);
    }

    @Override
    public void setDefaultValue(String prop) {
        this.defaultValue = null;
        if (prop == null) {
            return;
        }
        this.defaultValue = Short.valueOf(prop);
    }

    @Override
    public void setEmptyValue(String prop) {
        this.emptyValue = null;
        if (prop == null) {
            return;
        }
        this.emptyValue = Short.valueOf(prop);
    }

    @Override
    protected Object getSafeEmptyValue() {
        if (this.isMultiValued()) {
            return new short[0];
        }
        return null == this.getEmptyValue() ? Short.valueOf((short)0) : (Short)this.getEmptyValue();
    }

    @Override
    protected String getDefaultValidator() {
        return ShortValidator.class.getName();
    }

    @Override
    protected void doSetValue() {
        if (this.isMultiValued()) {
            Integer[] inputs = this.parser.getIntObjects(this.getKey());
            short[] values = new short[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                values[i] = inputs[i] == null ? ((Short)this.getEmptyValue()).shortValue() : inputs[i].shortValue();
            }
            this.setTestValue(values);
        } else {
            Integer value = this.parser.getIntObject(this.getKey());
            if (value == null) {
                this.setTestValue(this.getEmptyValue());
            } else {
                this.setTestValue(value.shortValue());
            }
        }
    }
}

