/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.json.jackson;

import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;

public class SimpleNameIntrospector
extends NopAnnotationIntrospector
implements LogEnabled {
    private static final long serialVersionUID = 1L;
    private List<Class<?>> filteredClasses = new CopyOnWriteArrayList();
    private List<String> externalFilterExcludeClasses = new CopyOnWriteArrayList<String>();
    private List<String> externalFilterIncludeClasses = new CopyOnWriteArrayList<String>();
    private AtomicBoolean isExludeType = new AtomicBoolean(false);
    private static Logger logger;

    public Boolean isIgnorableType(AnnotatedClass ac) {
        Boolean isIgnorable = super.isIgnorableType(ac);
        if (isIgnorable == null || !isIgnorable.booleanValue()) {
            if (this.getIsExludeType()) {
                if (!this.externalFilterExcludeClasses.isEmpty() && this.externalFilterExcludeClasses.contains(ac.getName())) {
                    isIgnorable = true;
                }
            } else if (!this.externalFilterIncludeClasses.isEmpty() && !this.externalFilterIncludeClasses.contains(ac.getName())) {
                try {
                    Class.forName(ac.getName());
                    isIgnorable = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return isIgnorable;
    }

    public Object findFilterId(Annotated ac) {
        Object id = super.findFilterId(ac);
        if (id == null) {
            String name = ac.getName();
            Class targetClazz = ac.getRawType();
            if (!this.filteredClasses.isEmpty() && this.filteredClasses.contains(targetClazz)) {
                logger.debug("filter applying to " + name);
                id = name;
            } else {
                for (Class<?> filterClazz : this.filteredClasses) {
                    if (filterClazz.isAssignableFrom(targetClazz)) {
                        logger.debug("filter applying to parent " + filterClazz + " matching child class " + name);
                        id = name;
                        break;
                    }
                    if (!targetClazz.isAssignableFrom(filterClazz)) continue;
                    logger.debug("filter applying to child " + filterClazz + " matching parent class " + name);
                    id = name;
                    break;
                }
            }
        }
        return id;
    }

    public List<Class<?>> getFilteredClasses() {
        return this.filteredClasses;
    }

    public void setFilteredClass(Class<?> filteredClass) {
        if (!this.filteredClasses.contains(filteredClass)) {
            this.filteredClasses.add(filteredClass);
        }
    }

    public void setFilteredClasses(Class<?> ... classes) {
        for (int i = 0; i < classes.length; ++i) {
            if (this.filteredClasses.contains(classes[i])) continue;
            this.filteredClasses.add(classes[i]);
        }
    }

    public void removeFilteredClass(Class<?> filteredClass) {
        if (this.filteredClasses.contains(filteredClass)) {
            this.filteredClasses.remove(filteredClass);
        }
    }

    public void setExternalFilterExcludeClasses(Class<?> ... classes) {
        for (int i = 0; i < classes.length; ++i) {
            if (this.externalFilterExcludeClasses.contains(classes[i].getName())) continue;
            this.externalFilterExcludeClasses.add(classes[i].getName());
        }
    }

    public void removeExternalFilterExcludeClass(Class<?> externalFilterClass) {
        if (this.externalFilterExcludeClasses.contains(externalFilterClass.getName())) {
            this.externalFilterExcludeClasses.remove(externalFilterClass.getName());
        }
    }

    public void setExternalFilterIncludeClasses(Class<?> ... classes) {
        for (int i = 0; i < classes.length; ++i) {
            if (this.externalFilterIncludeClasses.contains(classes[i].getName())) continue;
            this.externalFilterIncludeClasses.add(classes[i].getName());
        }
    }

    public void removeExternalFilterIncludeClasses(Class<?> externalFilterClass) {
        if (this.externalFilterIncludeClasses.contains(externalFilterClass.getName())) {
            this.externalFilterIncludeClasses.remove(externalFilterClass.getName());
        }
    }

    public boolean getIsExludeType() {
        return this.isExludeType.get();
    }

    public void setIsExludeType(boolean isExludeType) {
        this.isExludeType.getAndSet(isExludeType);
    }

    public void enableLogging(Logger logger) {
        SimpleNameIntrospector.logger = logger;
    }
}

