/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.turbine;

import java.sql.Connection;
import java.util.List;
import java.util.Set;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.model.turbine.entity.TurbinePermission;
import org.apache.fulcrum.security.torque.om.TurbinePermissionPeer;
import org.apache.fulcrum.security.torque.om.TurbineRolePermission;
import org.apache.fulcrum.security.torque.om.TurbineRolePermissionPeer;
import org.apache.fulcrum.security.torque.peer.TurbineRolePermissionPeerMapper;
import org.apache.fulcrum.security.torque.security.TorqueAbstractSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.SimpleKey;

public abstract class DefaultAbstractTurbinePermission
extends TorqueAbstractSecurityEntity
implements TurbinePermission {
    private static final long serialVersionUID = -5313324873688923207L;
    private Set<Role> roleSet = null;

    protected <T extends TurbineRolePermissionPeerMapper> List<T> getTurbineRolePermissionsJoinTurbineRole(Criteria criteria, Connection con) throws TorqueException {
        criteria.and((Object)TurbineRolePermissionPeer.PERMISSION_ID, (Object)this.getEntityId());
        return TurbineRolePermissionPeer.doSelectJoinTurbineRole(criteria, con);
    }

    public void addRole(Role role) {
        this.getRoles().add((SecurityEntity)role);
    }

    public RoleSet getRoles() {
        if (this.roleSet == null) {
            this.roleSet = new RoleSet();
        } else if (!(this.roleSet instanceof RoleSet)) {
            this.roleSet = new RoleSet(this.roleSet);
        }
        return (RoleSet)this.roleSet;
    }

    public <T extends Role> Set<T> getRolesAsSet() {
        return this.roleSet;
    }

    public void removeRole(Role role) {
        this.getRoles().remove((Object)role);
    }

    public void setRoles(RoleSet roleSet) {
        this.roleSet = roleSet != null ? roleSet : new RoleSet();
    }

    public <T extends Role> void setRolesAsSet(Set<T> roles) {
        this.setRoles(new RoleSet(roles));
    }

    @Override
    public void retrieveAttachedObjects(Connection con) throws DataBackendException {
        this.retrieveAttachedObjects(con, false);
    }

    @Override
    public void retrieveAttachedObjects(Connection con, Boolean lazy) throws DataBackendException {
        try {
            this.roleSet = new RoleSet();
            List rolepermissions = this.getTurbineRolePermissionsJoinTurbineRole(new Criteria(), con);
            for (TurbineRolePermissionPeerMapper ttrp : rolepermissions) {
                this.roleSet.add(ttrp.getTurbineRole());
            }
        }
        catch (TorqueException e) {
            throw new DataBackendException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void update(Connection con) throws TorqueException {
        if (this.roleSet != null && !this.roleSet.isEmpty()) {
            Criteria criteria = new Criteria();
            criteria.where((Object)TurbineRolePermissionPeer.PERMISSION_ID, (Object)this.getEntityId());
            TurbineRolePermissionPeer.doDelete(criteria, con);
            for (Role r : this.roleSet) {
                TurbineRolePermission rp = new TurbineRolePermission();
                rp.setRoleId((Integer)r.getId());
                rp.setPermissionId(this.getEntityId());
                rp.save(con);
            }
        }
        try {
            this.save(con);
        }
        catch (Exception e) {
            throw new TorqueException((Throwable)e);
        }
    }

    @Override
    public void delete() throws TorqueException {
        TurbinePermissionPeer.doDelete(SimpleKey.keyFor((Number)this.getEntityId()));
    }
}

