/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.container;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fulcrum.yaafi.container.Container;
import org.apache.fulcrum.yaafi.container.ContainerImpl;

public class DefaultContainerSetup {
    public static final String CONTAINER_YAAFI = "CONTAINER_YAAFI";
    public static final String COMPONENT_APP_ROOT = "componentAppRoot";
    private String containerType = "CONTAINER_YAAFI";
    public static final int defaultLogLevel = 1;
    private Container container;
    private String configurationFileName = "/DefaultComponentConfig.xml";
    private String roleFileName = "/DefaultRoleConfig.xml";
    private String parameterFileName = null;
    private int logLevel = 1;
    public Map<String, Object> attributes = new HashMap<String, Object>();
    public int maxInactiveInterval = 0;

    public void setConfigurationFileName(String configurationFileName) {
        this.configurationFileName = configurationFileName;
    }

    public void setRoleFileName(String roleFileName) {
        this.roleFileName = roleFileName;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void tearDown() {
        if (this.container != null) {
            this.container.dispose();
        }
        this.container = null;
    }

    public String getConfigurationFileName() {
        return this.configurationFileName;
    }

    public String getRoleFileName() {
        return this.roleFileName;
    }

    public String getParameterFileName() {
        return this.parameterFileName;
    }

    public Object lookup(String roleName) throws ComponentException {
        if (this.container == null) {
            ConsoleLogger log = new ConsoleLogger();
            this.container = new ContainerImpl((Logger)log);
            this.container.startup(this.getConfigurationFileName(), this.getRoleFileName(), this.getParameterFileName());
        }
        return this.container.lookup(roleName);
    }

    public void release(Object component) {
        if (this.container != null) {
            this.container.release(component);
        }
    }

    public String getContainerType() {
        return this.containerType;
    }

    public void setContainerType(String containerType) {
        this.containerType = containerType;
    }
}

