/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.ReadableDeviceCategory;

@Immutable
public final class DeviceCategory
implements ReadableDeviceCategory,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final DeviceCategory EMPTY = new DeviceCategory();
    @Nonnull
    private final ReadableDeviceCategory.Category category;
    @Nonnull
    private final String icon;
    @Nonnull
    private final String infoUrl;
    @Nonnull
    private final String name;
    private final int hash;

    private static int buildHashCode(@Nonnull ReadableDeviceCategory.Category category, @Nonnull String icon, @Nonnull String infoUrl, @Nonnull String name) {
        int prime = 31;
        int result = 1;
        result = 31 * result + category.hashCode();
        result = 31 * result + icon.hashCode();
        result = 31 * result + infoUrl.hashCode();
        result = 31 * result + name.hashCode();
        return result;
    }

    private DeviceCategory() {
        this.category = ReadableDeviceCategory.Category.UNKNOWN;
        this.icon = "";
        this.infoUrl = "";
        this.name = "";
        this.hash = DeviceCategory.buildHashCode(this.category, this.icon, this.infoUrl, this.name);
    }

    public DeviceCategory(@Nonnull ReadableDeviceCategory.Category category, @Nonnull String icon, @Nonnull String infoUrl, @Nonnull String name) {
        this.category = (ReadableDeviceCategory.Category)((Object)Check.notNull((Object)((Object)category), (String)"category"));
        this.icon = (String)Check.notNull((Object)icon, (String)"icon");
        this.infoUrl = (String)Check.notNull((Object)infoUrl, (String)"infoUrl");
        this.name = (String)Check.notEmpty((CharSequence)name, (String)"name");
        this.hash = DeviceCategory.buildHashCode(category, icon, infoUrl, name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceCategory other = (DeviceCategory)obj;
        if (!this.category.equals((Object)other.category)) {
            return false;
        }
        if (!this.icon.equals(other.icon)) {
            return false;
        }
        if (!this.infoUrl.equals(other.infoUrl)) {
            return false;
        }
        return this.name.equals(other.name);
    }

    @Override
    @Nonnull
    public ReadableDeviceCategory.Category getCategory() {
        return this.category;
    }

    @Override
    @Nonnull
    public String getIcon() {
        return this.icon;
    }

    @Override
    @Nonnull
    public String getInfoUrl() {
        return this.infoUrl;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "DeviceCategory [category=" + (Object)((Object)this.category) + ", icon=" + this.icon + ", infoUrl=" + this.infoUrl + ", name=" + this.name + "]";
    }

    @NotThreadSafe
    public static final class Builder {
        private ReadableDeviceCategory.Category category;
        private String icon;
        private String infoUrl;
        private String name;

        public Builder() {
        }

        public Builder(@Nonnull DeviceCategory deviceCategory) {
            Check.notNull((Object)deviceCategory, (String)"deviceCategory");
            this.category = (ReadableDeviceCategory.Category)((Object)Check.notNull((Object)((Object)deviceCategory.getCategory()), (String)"deviceCategory.getCategory()"));
            this.icon = (String)Check.notNull((Object)deviceCategory.getIcon(), (String)"deviceCategory.getIcon()");
            this.infoUrl = (String)Check.notNull((Object)deviceCategory.getInfoUrl(), (String)"deviceCategory.getInfoUrl()");
            this.name = (String)Check.notNull((Object)deviceCategory.getName(), (String)"deviceCategory.getName()");
        }

        @Nonnull
        public DeviceCategory build() {
            return new DeviceCategory(this.category, this.icon, this.infoUrl, this.name);
        }

        @Nonnull
        public Builder setCategory(@Nonnull ReadableDeviceCategory.Category category) {
            this.category = (ReadableDeviceCategory.Category)((Object)Check.notNull((Object)((Object)category), (String)"category"));
            return this;
        }

        @Nonnull
        public Builder setIcon(@Nonnull String icon) {
            this.icon = (String)Check.notNull((Object)icon, (String)"icon");
            return this;
        }

        @Nonnull
        public Builder setInfoUrl(@Nonnull String infoUrl) {
            this.infoUrl = (String)Check.notNull((Object)infoUrl, (String)"infoUrl");
            return this;
        }

        @Nonnull
        public Builder setName(@Nonnull String name) {
            this.name = (String)Check.notNull((Object)name, (String)"name");
            return this;
        }
    }
}

