/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Sync;

public class LayeredSync
implements Sync {
    protected final Sync outer_;
    protected final Sync inner_;

    public LayeredSync(Sync outer, Sync inner) {
        this.outer_ = outer;
        this.inner_ = inner;
    }

    public void acquire() throws InterruptedException {
        this.outer_.acquire();
        try {
            this.inner_.acquire();
        }
        catch (InterruptedException ex) {
            this.outer_.release();
            throw ex;
        }
    }

    public boolean attempt(long msecs) throws InterruptedException {
        long start = msecs <= 0L ? 0L : System.currentTimeMillis();
        long waitTime = msecs;
        if (this.outer_.attempt(waitTime)) {
            try {
                if (msecs > 0L) {
                    waitTime = msecs - (System.currentTimeMillis() - start);
                }
                if (this.inner_.attempt(waitTime)) {
                    return true;
                }
                this.outer_.release();
                return false;
            }
            catch (InterruptedException ex) {
                this.outer_.release();
                throw ex;
            }
        }
        return false;
    }

    public void release() {
        this.inner_.release();
        this.outer_.release();
    }
}

