/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.localization;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.localization.LocalizationService;
import org.apache.fulcrum.localization.SimpleLocalizationService;

public class SimpleLocalizationServiceImpl
extends AbstractLogEnabled
implements SimpleLocalizationService,
Configurable,
Initializable {
    private static final String BUNDLES = "bundles";
    private static final Object[] NO_ARGS = new Object[0];
    private HashMap<String, HashMap<Locale, ResourceBundle>> bundles = new HashMap();
    private String[] bundleNames = null;
    private Locale defaultLocale = null;
    private String defaultLanguage = null;
    private String defaultCountry = null;

    public void configure(Configuration conf) throws ConfigurationException {
        Locale jvmDefault = Locale.getDefault();
        this.defaultLanguage = conf.getAttribute("locale-default-language", jvmDefault.getLanguage()).trim();
        this.defaultCountry = conf.getAttribute("locale-default-country", jvmDefault.getCountry()).trim();
        this.getLogger().info("initialized lang=" + this.defaultLanguage + " country=" + this.defaultCountry);
        Configuration bundles = conf.getChild(BUNDLES, false);
        if (bundles != null) {
            Configuration[] nameVal = bundles.getChildren();
            String[] bundleName = new String[nameVal.length];
            for (int i = 0; i < nameVal.length; ++i) {
                String val = nameVal[i].getValue();
                this.getLogger().debug("Registered bundle " + val);
                bundleName[i] = val;
            }
            this.initBundleNames(bundleName);
        }
    }

    public void initialize() throws Exception {
        this.defaultLocale = new Locale(this.defaultLanguage, this.defaultCountry);
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Localization Service is Initialized now..");
        }
    }

    protected void initBundleNames(String[] intBundleNames) {
        this.bundleNames = intBundleNames == null ? new String[0] : intBundleNames;
    }

    @Override
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public String getDefaultCountry() {
        return this.defaultCountry;
    }

    @Override
    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public String getDefaultBundleName() {
        return this.bundleNames.length > 0 ? this.bundleNames[0] : "";
    }

    @Override
    public String[] getBundleNames() {
        return (String[])this.bundleNames.clone();
    }

    @Override
    public ResourceBundle getBundle() {
        return this.getBundle(this.getDefaultBundleName(), null);
    }

    @Override
    public ResourceBundle getBundle(String bundleName) {
        return this.getBundle(bundleName, null);
    }

    @Override
    public ResourceBundle getBundle(String bundleName, Locale locale) {
        String string = bundleName = bundleName == null ? this.getDefaultBundleName() : bundleName.trim();
        if (locale == null) {
            locale = this.getDefaultLocale();
        }
        ResourceBundle rb = null;
        HashMap<Locale, ResourceBundle> bundlesByLocale = this.bundles.get(bundleName);
        if (bundlesByLocale != null) {
            rb = bundlesByLocale.get(locale);
            if (rb == null) {
                rb = this.cacheBundle(bundleName, locale);
            }
        } else {
            rb = this.cacheBundle(bundleName, locale);
        }
        return rb;
    }

    private synchronized ResourceBundle cacheBundle(String bundleName, Locale locale) throws MissingResourceException {
        ResourceBundle rb;
        HashMap<Locale, ResourceBundle> bundlesByLocale = this.bundles.get(bundleName);
        ResourceBundle resourceBundle = rb = bundlesByLocale == null ? null : bundlesByLocale.get(locale);
        if (rb == null) {
            block4: {
                bundlesByLocale = bundlesByLocale == null ? new HashMap(3) : new HashMap<Locale, ResourceBundle>(bundlesByLocale);
                try {
                    rb = ResourceBundle.getBundle(bundleName, locale);
                }
                catch (MissingResourceException e) {
                    rb = this.findBundleByLocale(bundleName, locale, bundlesByLocale);
                    if (rb != null) break block4;
                    throw (MissingResourceException)e.fillInStackTrace();
                }
            }
            if (rb != null) {
                bundlesByLocale.put(rb.getLocale(), rb);
                HashMap<String, HashMap<Locale, ResourceBundle>> bundlesByName = new HashMap<String, HashMap<Locale, ResourceBundle>>(this.bundles);
                bundlesByName.put(bundleName, bundlesByLocale);
                this.bundles = bundlesByName;
            }
        }
        return rb;
    }

    private ResourceBundle findBundleByLocale(String bundleName, Locale locale, Map<Locale, ResourceBundle> bundlesByLocale) {
        Locale withDefaultLanguage;
        ResourceBundle rb = null;
        if (StringUtils.isEmpty((CharSequence)locale.getCountry()) && this.defaultLanguage.equals(locale.getLanguage())) {
            Locale withDefaultCountry = new Locale(locale.getLanguage(), this.defaultCountry);
            rb = bundlesByLocale.get(withDefaultCountry);
            if (rb == null) {
                rb = this.getBundleIgnoreException(bundleName, withDefaultCountry);
            }
        } else if (StringUtils.isEmpty((CharSequence)locale.getLanguage()) && this.defaultCountry.equals(locale.getCountry()) && (rb = bundlesByLocale.get(withDefaultLanguage = new Locale(this.defaultLanguage, locale.getCountry()))) == null) {
            rb = this.getBundleIgnoreException(bundleName, withDefaultLanguage);
        }
        if (rb == null && !this.defaultLocale.equals(locale)) {
            rb = this.getBundleIgnoreException(bundleName, this.defaultLocale);
        }
        return rb;
    }

    private final ResourceBundle getBundleIgnoreException(String bundleName, Locale locale) {
        try {
            return ResourceBundle.getBundle(bundleName, locale);
        }
        catch (MissingResourceException ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBundle(String defaultBundle) {
        if (this.bundleNames.length > 0) {
            this.bundleNames[0] = defaultBundle;
        } else {
            SimpleLocalizationServiceImpl simpleLocalizationServiceImpl = this;
            synchronized (simpleLocalizationServiceImpl) {
                if (this.bundleNames.length <= 0) {
                    this.bundleNames = new String[]{defaultBundle};
                }
            }
        }
    }

    @Override
    public String getString(String bundleName, Locale locale, String key) throws MissingResourceException {
        ResourceBundle rb;
        String value = null;
        if (locale == null) {
            locale = this.getDefaultLocale();
        }
        if ((value = this.getStringOrNull(rb = this.getBundle(bundleName, locale), key)) == null && this.bundleNames.length > 0) {
            for (int i = 0; i < this.bundleNames.length; ++i) {
                String name = this.bundleNames[i];
                if (name.equals(bundleName) || (value = this.getStringOrNull(rb = this.getBundle(name, locale), key)) == null) continue;
                locale = rb.getLocale();
                break;
            }
        }
        if (value == null) {
            String loc = locale.toString();
            String mesg = LocalizationService.SERVICE_NAME + " noticed missing resource: bundleName=" + bundleName + ", locale=" + loc + ", key=" + key;
            this.getLogger().debug(mesg);
            throw new MissingResourceException(mesg, bundleName, key);
        }
        return value;
    }

    @Override
    public String getString(String key) {
        return this.getString(this.getDefaultBundleName(), this.getDefaultLocale(), key);
    }

    protected final String getStringOrNull(ResourceBundle rb, String key) {
        if (rb != null) {
            try {
                return rb.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String format(String bundleName, Locale locale, String key, Object arg1) {
        return this.format(bundleName, locale, key, new Object[]{arg1});
    }

    @Override
    public String format(String bundleName, Locale locale, String key, Object arg1, Object arg2) {
        return this.format(bundleName, locale, key, new Object[]{arg1, arg2});
    }

    @Override
    public String format(String bundleName, Locale locale, String key, Object[] args) {
        Locale formatLocale = locale == null ? this.getDefaultLocale() : locale;
        String value = this.getString(bundleName, locale, key);
        Object[] formatArgs = args == null ? NO_ARGS : args;
        MessageFormat messageFormat = new MessageFormat(value, formatLocale);
        return messageFormat.format(formatArgs);
    }
}

