/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.output;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.Deflater;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.GetShuffleServerRequest;
import org.apache.tez.common.GetShuffleServerResponse;
import org.apache.tez.common.RssTezUtils;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezRemoteShuffleUmbilicalProtocol;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.AbstractLogicalOutput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.Writer;
import org.apache.tez.runtime.library.api.KeyValuesWriter;
import org.apache.tez.runtime.library.common.MemoryUpdateCallbackHandler;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.apache.tez.runtime.library.common.sort.impl.ExternalSorter;
import org.apache.tez.runtime.library.common.sort.impl.RssTezPerPartitionRecord;
import org.apache.tez.runtime.library.common.sort.impl.RssUnSorter;
import org.apache.tez.runtime.library.common.sort.impl.TezSpillRecord;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.shaded.com.google.common.base.Preconditions;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class RssUnorderedPartitionedKVOutput
extends AbstractLogicalOutput {
    private static final Logger LOG = LoggerFactory.getLogger(RssUnorderedPartitionedKVOutput.class);
    protected ExternalSorter sorter;
    protected Configuration conf;
    protected MemoryUpdateCallbackHandler memoryUpdateCallbackHandler;
    private long startTime;
    private long endTime;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final Deflater deflater;
    private Map<Integer, List<ShuffleServerInfo>> partitionToServers;
    private int mapNum;
    private int numOutputs;
    private TezTaskAttemptID taskAttemptId;
    private ApplicationId applicationId;
    private boolean sendEmptyPartitionDetails;
    private OutputContext outputContext;
    private String host;
    private int port;
    private String taskVertexName;
    private String destinationVertexName;
    private int shuffleId;
    private ApplicationAttemptId applicationAttemptId;
    private static final Set<String> confKeys = new HashSet<String>();

    public RssUnorderedPartitionedKVOutput(OutputContext outputContext, int numPhysicalOutputs) {
        super(outputContext, numPhysicalOutputs);
        this.outputContext = outputContext;
        this.deflater = TezCommonUtils.newBestCompressionDeflater();
        this.numOutputs = this.getNumPhysicalOutputs();
        this.mapNum = outputContext.getVertexParallelism();
        this.applicationId = outputContext.getApplicationId();
        this.taskAttemptId = TezTaskAttemptID.fromString((String)RssTezUtils.uniqueIdentifierToAttemptId(outputContext.getUniqueIdentifier()));
        this.taskVertexName = outputContext.getTaskVertexName();
        this.destinationVertexName = outputContext.getDestinationVertexName();
        LOG.info("taskAttemptId is {}", (Object)this.taskAttemptId.toString());
        LOG.info("taskVertexName is {}", (Object)this.taskVertexName);
        LOG.info("destinationVertexName is {}", (Object)this.destinationVertexName);
        LOG.info("Initialized RssUnOrderedPartitionedKVOutput.");
    }

    public List<Event> initialize() throws Exception {
        this.startTime = System.nanoTime();
        this.conf = TezUtils.createConfFromUserPayload((UserPayload)this.getContext().getUserPayload());
        this.memoryUpdateCallbackHandler = new MemoryUpdateCallbackHandler();
        long memRequestSize = RssTezUtils.getInitialMemoryRequirement(this.conf, this.getContext().getTotalMemoryAvailableToTask());
        LOG.info("memRequestSize is {}", (Object)memRequestSize);
        this.getContext().requestInitialMemory(memRequestSize, (MemoryUpdateCallback)this.memoryUpdateCallbackHandler);
        LOG.info("Got initialMemory.");
        this.sendEmptyPartitionDetails = this.conf.getBoolean("tez.runtime.empty.partitions.info-via-events.enabled", true);
        this.host = this.conf.get("tez.rss.am.shuffle.manager.address");
        this.port = this.conf.getInt("tez.rss.am.shuffle.manager.port", -1);
        final InetSocketAddress address = NetUtils.createSocketAddrForHost((String)this.host, (int)this.port);
        UserGroupInformation taskOwner = UserGroupInformation.createRemoteUser((String)this.applicationId.toString());
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        Token jobToken = TokenCache.getSessionToken((Credentials)credentials);
        SecurityUtil.setTokenService((Token)jobToken, (InetSocketAddress)address);
        taskOwner.addToken(jobToken);
        TezRemoteShuffleUmbilicalProtocol umbilical = (TezRemoteShuffleUmbilicalProtocol)taskOwner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TezRemoteShuffleUmbilicalProtocol>(){

            @Override
            public TezRemoteShuffleUmbilicalProtocol run() throws Exception {
                return (TezRemoteShuffleUmbilicalProtocol)RPC.getProxy(TezRemoteShuffleUmbilicalProtocol.class, (long)31L, (InetSocketAddress)address, (Configuration)RssUnorderedPartitionedKVOutput.this.conf);
            }
        });
        TezVertexID tezVertexID = this.taskAttemptId.getTaskID().getVertexID();
        TezDAGID tezDAGID = tezVertexID.getDAGId();
        int sourceVertexId = this.conf.getInt("tez.rss.shuffle.source.vertex.id", -1);
        int destinationVertexId = this.conf.getInt("tez.rss.shuffle.destination.vertex.id", -1);
        assert (sourceVertexId != -1);
        assert (destinationVertexId != -1);
        this.shuffleId = RssTezUtils.computeShuffleId(tezDAGID.getId(), sourceVertexId, destinationVertexId);
        this.applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.outputContext.getApplicationId(), (int)this.outputContext.getDAGAttemptNumber());
        GetShuffleServerRequest request = new GetShuffleServerRequest(this.taskAttemptId, this.mapNum, this.numOutputs, this.shuffleId);
        GetShuffleServerResponse response = umbilical.getShuffleAssignments(request);
        this.partitionToServers = response.getShuffleAssignmentsInfoWritable().getShuffleAssignmentsInfo().getPartitionToServers();
        LOG.info("Got response from am.");
        return Collections.emptyList();
    }

    public void handleEvents(List<Event> list) {
    }

    public List<Event> close() throws Exception {
        LinkedList<Event> returnEvents = Lists.newLinkedList();
        if (this.sorter != null) {
            this.sorter.flush();
            this.sorter.close();
            this.endTime = System.nanoTime();
            returnEvents.addAll(this.generateEvents());
            this.sorter = null;
        } else {
            LOG.warn(this.getContext().getDestinationVertexName() + ": Attempting to close output {} of type {} before it was started. Generating empty events", (Object)this.getContext().getDestinationVertexName(), (Object)((Object)((Object)this)).getClass().getSimpleName());
            returnEvents = this.generateEmptyEvents();
        }
        LOG.info("RssUnorderedPartitionedKVOutput close.");
        return returnEvents;
    }

    public void start() throws Exception {
        if (!this.isStarted.get()) {
            this.memoryUpdateCallbackHandler.validateUpdateReceived();
            long rssTaskAttemptId = RssTezUtils.createRssTaskAttemptId(this.taskAttemptId, this.conf);
            this.sorter = new RssUnSorter(this.taskAttemptId, this.getContext(), this.conf, this.mapNum, this.numOutputs, this.memoryUpdateCallbackHandler.getMemoryAssigned(), this.shuffleId, this.applicationAttemptId, this.partitionToServers, rssTaskAttemptId);
            LOG.info("Initialized RssUnSorter.");
            this.isStarted.set(true);
        }
    }

    public Writer getWriter() throws IOException {
        Preconditions.checkState(this.isStarted.get(), "Cannot get writer before starting the Output");
        return new KeyValuesWriter(){

            public void write(Object key, Iterable<Object> values) throws IOException {
                RssUnorderedPartitionedKVOutput.this.sorter.write(key, values);
            }

            public void write(Object key, Object value) throws IOException {
                RssUnorderedPartitionedKVOutput.this.sorter.write(key, value);
            }
        };
    }

    private List<Event> generateEvents() throws IOException {
        LinkedList<Event> eventList = Lists.newLinkedList();
        boolean isLastEvent = true;
        String auxiliaryService = this.conf.get("tez.am.shuffle.auxiliary-service.id", "mapreduce_shuffle");
        int[] numRecordsPerPartition = ((RssUnSorter)this.sorter).getNumRecordsPerPartition();
        RssTezPerPartitionRecord rssTezPerPartitionRecord = new RssTezPerPartitionRecord(this.numOutputs, numRecordsPerPartition);
        LOG.info("RssTezPerPartitionRecord is initialized");
        ShuffleUtils.generateEventOnSpill(eventList, (boolean)true, (boolean)isLastEvent, (OutputContext)this.getContext(), (int)0, (TezSpillRecord)rssTezPerPartitionRecord, (int)this.getNumPhysicalOutputs(), (boolean)this.sendEmptyPartitionDetails, (String)this.getContext().getUniqueIdentifier(), (long[])this.sorter.getPartitionStats(), (boolean)this.sorter.reportDetailedPartitionStats(), (String)auxiliaryService, (Deflater)this.deflater);
        LOG.info("Generate events.");
        return eventList;
    }

    private List<Event> generateEmptyEvents() throws IOException {
        ArrayList<Event> eventList = Lists.newArrayList();
        ShuffleUtils.generateEventsForNonStartedOutput(eventList, (int)this.getNumPhysicalOutputs(), (OutputContext)this.getContext(), (boolean)true, (boolean)true, (Deflater)this.deflater);
        LOG.info("Generate empty events.");
        return eventList;
    }

    @InterfaceAudience.Private
    public static Set<String> getConfigurationKeySet() {
        return Collections.unmodifiableSet(confKeys);
    }

    static {
        confKeys.add("tez.runtime.ifile.readahead");
        confKeys.add("tez.runtime.ifile.readahead.bytes");
        confKeys.add("io.file.buffer.size");
        confKeys.add("tez.runtime.index.cache.memory.limit.bytes");
        confKeys.add("tez.runtime.unordered.output.buffer.size-mb");
        confKeys.add("tez.runtime.unordered.output.max-per-buffer.size-bytes");
        confKeys.add("tez.runtime.partitioner.class");
        confKeys.add("tez.runtime.key.class");
        confKeys.add("tez.runtime.value.class");
        confKeys.add("tez.runtime.compress");
        confKeys.add("tez.runtime.compress.codec");
        confKeys.add("tez.runtime.empty.partitions.info-via-events.enabled");
        confKeys.add("tez.runtime.convert.user-payload.to.history-text");
        confKeys.add("tez.runtime.pipelined-shuffle.enabled");
        confKeys.add("tez.runtime.enable.final-merge.in.output");
        confKeys.add("tez.counters.max");
        confKeys.add("tez.counters.group-name.max-length");
        confKeys.add("tez.counters.counter-name.max-length");
        confKeys.add("tez.counters.max.groups");
        confKeys.add("tez.runtime.cleanup.files.on.interrupt");
        confKeys.add("tez.runtime.report.partition.stats");
        confKeys.add("tez.am.shuffle.auxiliary-service.id");
        confKeys.add("tez.runtime.unordered-partitioned-kvwriter.buffer-merge-percent");
    }
}

