/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext;
import org.apache.spark.shuffle.RssShuffleManager;
import org.apache.spark.shuffle.RssSparkConfig;
import org.apache.spark.shuffle.RssSparkShuffleUtils;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.uniffle.client.api.CoordinatorClient;
import org.apache.uniffle.client.request.RssAccessClusterRequest;
import org.apache.uniffle.client.response.RssAccessClusterResponse;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.RetryUtils;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.apache.uniffle.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegationRssShuffleManager
implements ShuffleManager {
    private static final Logger LOG = LoggerFactory.getLogger(DelegationRssShuffleManager.class);
    private final ShuffleManager delegate;
    private final List<CoordinatorClient> coordinatorClients;
    private final int accessTimeoutMs;
    private final SparkConf sparkConf;
    private String user;
    private String uuid;

    public DelegationRssShuffleManager(SparkConf sparkConf, boolean isDriver) throws Exception {
        this.sparkConf = sparkConf;
        this.accessTimeoutMs = (Integer)sparkConf.get(RssSparkConfig.RSS_ACCESS_TIMEOUT_MS);
        if (isDriver) {
            this.coordinatorClients = RssSparkShuffleUtils.createCoordinatorClients(sparkConf);
            this.delegate = this.createShuffleManagerInDriver();
        } else {
            this.coordinatorClients = Lists.newArrayList();
            this.delegate = this.createShuffleManagerInExecutor();
        }
        if (this.delegate == null) {
            throw new RssException("Fail to create shuffle manager!");
        }
    }

    private ShuffleManager createShuffleManagerInDriver() throws RssException {
        ShuffleManager shuffleManager;
        this.user = "user";
        try {
            this.user = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (Exception e) {
            LOG.error("Error on getting user from ugi." + e);
        }
        boolean canAccess = this.tryAccessCluster();
        if (this.uuid == null || "".equals(this.uuid)) {
            this.uuid = String.valueOf(System.currentTimeMillis());
        }
        if (canAccess) {
            try {
                this.sparkConf.set("spark.rss.quota.user", this.user);
                this.sparkConf.set("spark.rss.quota.uuid", this.uuid);
                RssShuffleManager shuffleManager2 = new RssShuffleManager(this.sparkConf, true);
                this.sparkConf.set(RssSparkConfig.RSS_ENABLED.key(), "true");
                this.sparkConf.set("spark.shuffle.manager", RssShuffleManager.class.getCanonicalName());
                LOG.info("Use RssShuffleManager");
                return shuffleManager2;
            }
            catch (Exception exception) {
                LOG.warn("Fail to create RssShuffleManager, fallback to SortShuffleManager {}", (Object)exception.getMessage());
            }
        }
        try {
            shuffleManager = RssSparkShuffleUtils.loadShuffleManager("org.apache.spark.shuffle.sort.SortShuffleManager", this.sparkConf, true);
            this.sparkConf.set(RssSparkConfig.RSS_ENABLED.key(), "false");
            this.sparkConf.set("spark.shuffle.manager", "sort");
            LOG.info("Use SortShuffleManager");
        }
        catch (Exception e) {
            throw new RssException(e.getMessage());
        }
        return shuffleManager;
    }

    private boolean tryAccessCluster() {
        String accessId = this.sparkConf.get(RssSparkConfig.RSS_ACCESS_ID.key(), "").trim();
        if (StringUtils.isEmpty((CharSequence)accessId)) {
            LOG.warn("Access id key is empty");
            return false;
        }
        long retryInterval = (Long)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_ACCESS_RETRY_INTERVAL_MS);
        int retryTimes = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_ACCESS_RETRY_TIMES);
        int assignmentShuffleNodesNum = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_ASSIGNMENT_SHUFFLE_SERVER_NUMBER);
        HashMap<String, String> extraProperties = Maps.newHashMap();
        extraProperties.put("access_info_required_shuffle_nodes_num", String.valueOf(assignmentShuffleNodesNum));
        for (CoordinatorClient coordinatorClient : this.coordinatorClients) {
            Set<String> assignmentTags = RssSparkShuffleUtils.getAssignmentTags(this.sparkConf);
            try {
                boolean canAccess = RetryUtils.retry(() -> {
                    RssAccessClusterResponse response = coordinatorClient.accessCluster(new RssAccessClusterRequest(accessId, assignmentTags, this.accessTimeoutMs, extraProperties, this.user));
                    if (response.getStatusCode() == StatusCode.SUCCESS) {
                        LOG.warn("Success to access cluster {} using {}", (Object)coordinatorClient.getDesc(), (Object)accessId);
                        this.uuid = response.getUuid();
                        return true;
                    }
                    if (response.getStatusCode() == StatusCode.ACCESS_DENIED) {
                        throw new RssException("Request to access cluster " + coordinatorClient.getDesc() + " is denied using " + accessId + " for " + response.getMessage());
                    }
                    throw new RssException("Fail to reach cluster " + coordinatorClient.getDesc() + " for " + response.getMessage());
                }, retryInterval, retryTimes);
                return canAccess;
            }
            catch (Throwable e) {
                LOG.warn("Fail to access cluster {} using {} for {}", new Object[]{coordinatorClient.getDesc(), accessId, e.getMessage()});
            }
        }
        return false;
    }

    private ShuffleManager createShuffleManagerInExecutor() throws RssException {
        RssShuffleManager shuffleManager;
        boolean useRSS = (Boolean)this.sparkConf.get(RssSparkConfig.RSS_ENABLED);
        if (useRSS) {
            shuffleManager = new RssShuffleManager(this.sparkConf, false);
            LOG.info("Use RssShuffleManager");
        } else {
            try {
                shuffleManager = RssSparkShuffleUtils.loadShuffleManager("org.apache.spark.shuffle.sort.SortShuffleManager", this.sparkConf, false);
                LOG.info("Use SortShuffleManager");
            }
            catch (Exception e) {
                throw new RssException(e.getMessage());
            }
        }
        return shuffleManager;
    }

    public ShuffleManager getDelegate() {
        return this.delegate;
    }

    public <K, V, C> ShuffleHandle registerShuffle(int shuffleId, int numMaps, ShuffleDependency<K, V, C> dependency) {
        return this.delegate.registerShuffle(shuffleId, numMaps, dependency);
    }

    public <K, V> ShuffleWriter<K, V> getWriter(ShuffleHandle handle, int mapId, TaskContext context) {
        return this.delegate.getWriter(handle, mapId, context);
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context) {
        return this.delegate.getReader(handle, startPartition, endPartition, context);
    }

    public boolean unregisterShuffle(int shuffleId) {
        return this.delegate.unregisterShuffle(shuffleId);
    }

    public void stop() {
        this.delegate.stop();
        this.coordinatorClients.forEach(CoordinatorClient::close);
    }

    public ShuffleBlockResolver shuffleBlockResolver() {
        return this.delegate.shuffleBlockResolver();
    }
}

