/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.common.ClientType;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.storage.util.StorageType;

public class ClientUtils {
    public static RemoteStorageInfo fetchRemoteStorage(String appId, RemoteStorageInfo defaultRemoteStorage, boolean dynamicConfEnabled, String storageType, ShuffleWriteClient shuffleWriteClient) {
        RemoteStorageInfo remoteStorage = defaultRemoteStorage;
        if (storageType != null && StorageType.withRemoteStorage(StorageType.valueOf(storageType))) {
            if (remoteStorage.isEmpty() && dynamicConfEnabled) {
                remoteStorage = shuffleWriteClient.fetchRemoteStorage(appId);
            }
            if (remoteStorage.isEmpty()) {
                throw new IllegalStateException("Can't find remoteStorage: with storageType[" + storageType + "]");
            }
        }
        return remoteStorage;
    }

    public static boolean waitUntilDoneOrFail(List<CompletableFuture<Boolean>> futures, boolean allowFastFail) {
        int expected = futures.size();
        int failed = 0;
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        ArrayList<Future> finished = new ArrayList<Future>();
        while (true) {
            for (Future future : futures) {
                if (!future.isDone() || finished.contains(future)) continue;
                finished.add(future);
                try {
                    if (((Boolean)future.get()).booleanValue()) continue;
                    ++failed;
                }
                catch (Exception e) {
                    ++failed;
                }
            }
            if (expected == finished.size()) {
                return failed <= 0;
            }
            if (failed > 0 && allowFastFail) {
                futures.stream().filter(x -> !x.isDone()).forEach(x -> x.cancel(true));
                return false;
            }
            try {
                allFutures.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
            }
        }
    }

    public static void validateTestModeConf(boolean testMode, String storageType) {
        if (!testMode && (StorageType.LOCALFILE.name().equals(storageType) || StorageType.HDFS.name().equals(storageType))) {
            throw new IllegalArgumentException("LOCALFILE or HADOOP storage type should be used in test mode only, because of the poor performance of these two types.");
        }
    }

    public static void validateClientType(String clientType) {
        Set types = Arrays.stream(ClientType.values()).map(Enum::name).collect(Collectors.toSet());
        if (!types.contains(clientType)) {
            throw new IllegalArgumentException(String.format("The value of %s should be one of %s", clientType, types));
        }
    }

    public static int getMaxAttemptNo(int maxFailures, boolean speculation) {
        int maxAttemptNo;
        int n = maxAttemptNo = maxFailures < 1 ? 0 : maxFailures - 1;
        if (speculation) {
            ++maxAttemptNo;
        }
        return maxAttemptNo;
    }

    public static int getNumberOfSignificantBits(int number) {
        return 32 - Integer.numberOfLeadingZeros(number);
    }
}

