/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shaded.io.netty.handler.codec.protobuf;

import java.util.List;
import org.apache.uniffle.shaded.com.google.protobuf.ExtensionRegistry;
import org.apache.uniffle.shaded.com.google.protobuf.ExtensionRegistryLite;
import org.apache.uniffle.shaded.com.google.protobuf.MessageLite;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBuf;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBufUtil;
import org.apache.uniffle.shaded.io.netty.channel.ChannelHandler;
import org.apache.uniffle.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.uniffle.shaded.io.netty.handler.codec.MessageToMessageDecoder;
import org.apache.uniffle.shaded.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class ProtobufDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final boolean HAS_PARSER;
    private final MessageLite prototype;
    private final ExtensionRegistryLite extensionRegistry;

    public ProtobufDecoder(MessageLite prototype) {
        this(prototype, null);
    }

    public ProtobufDecoder(MessageLite prototype, ExtensionRegistry extensionRegistry) {
        this(prototype, (ExtensionRegistryLite)extensionRegistry);
    }

    public ProtobufDecoder(MessageLite prototype, ExtensionRegistryLite extensionRegistry) {
        this.prototype = ObjectUtil.checkNotNull(prototype, "prototype").getDefaultInstanceForType();
        this.extensionRegistry = extensionRegistry;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        int offset;
        byte[] array;
        int length = msg.readableBytes();
        if (msg.hasArray()) {
            array = msg.array();
            offset = msg.arrayOffset() + msg.readerIndex();
        } else {
            array = ByteBufUtil.getBytes(msg, msg.readerIndex(), length, false);
            offset = 0;
        }
        if (this.extensionRegistry == null) {
            if (HAS_PARSER) {
                out.add(this.prototype.getParserForType().parseFrom(array, offset, length));
            } else {
                out.add(this.prototype.newBuilderForType().mergeFrom(array, offset, length).build());
            }
        } else if (HAS_PARSER) {
            out.add(this.prototype.getParserForType().parseFrom(array, offset, length, this.extensionRegistry));
        } else {
            out.add(this.prototype.newBuilderForType().mergeFrom(array, offset, length, this.extensionRegistry).build());
        }
    }

    static {
        boolean hasParser = false;
        try {
            MessageLite.class.getDeclaredMethod("getParserForType", new Class[0]);
            hasParser = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HAS_PARSER = hasParser;
    }
}

