/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.common.RssTezConfig;
import org.apache.tez.common.RssTezUtils;
import org.apache.tez.common.TezIdHelper;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.FetchResult;
import org.apache.tez.runtime.library.common.shuffle.FetchedInputAllocator;
import org.apache.tez.runtime.library.common.shuffle.FetcherCallback;
import org.apache.tez.runtime.library.common.shuffle.impl.RssTezFetcher;
import org.apache.uniffle.client.api.ShuffleReadClient;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.client.factory.ShuffleClientFactory;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.util.UnitConverter;
import org.apache.uniffle.shaded.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RssTezFetcherTask
extends CallableWithNdc<FetchResult> {
    private static final Logger LOG = LoggerFactory.getLogger(RssTezFetcherTask.class);
    private final FetcherCallback fetcherCallback;
    private final InputContext inputContext;
    private final Configuration conf;
    private final FetchedInputAllocator inputManager;
    private final int partition;
    List<InputAttemptIdentifier> inputs;
    private Set<ShuffleServerInfo> serverInfoSet;
    Map<Integer, Roaring64NavigableMap> rssAllBlockIdBitmapMap;
    Map<Integer, Roaring64NavigableMap> rssSuccessBlockIdBitmapMap;
    private String clientType = null;
    private final int numPhysicalInputs;
    private final int dagIdentifier;
    private final int vertexIndex;
    private final int reduceId;
    private String storageType;
    private String basePath;
    private RemoteStorageInfo remoteStorageInfo;
    private final int readBufferSize;
    private final int partitionNumPerRange;
    private final int partitionNum;
    private final int shuffleId;
    private final ApplicationAttemptId applicationAttemptId;
    private final int maxAttemptNo;

    public RssTezFetcherTask(FetcherCallback fetcherCallback, InputContext inputContext, Configuration conf, FetchedInputAllocator inputManager, int partition, int shuffleId, ApplicationAttemptId applicationAttemptId, List<InputAttemptIdentifier> inputs, Set<ShuffleServerInfo> serverInfoList, Map<Integer, Roaring64NavigableMap> rssAllBlockIdBitmapMap, Map<Integer, Roaring64NavigableMap> rssSuccessBlockIdBitmapMap, int numPhysicalInputs, int partitionNum, int maxAttemptNo) {
        assert (inputs != null && inputs.size() > 0);
        this.fetcherCallback = fetcherCallback;
        this.inputContext = inputContext;
        this.conf = conf;
        this.inputManager = inputManager;
        this.partition = partition;
        this.inputs = inputs;
        this.shuffleId = shuffleId;
        this.applicationAttemptId = applicationAttemptId;
        this.serverInfoSet = serverInfoList;
        this.rssAllBlockIdBitmapMap = rssAllBlockIdBitmapMap;
        this.rssSuccessBlockIdBitmapMap = rssSuccessBlockIdBitmapMap;
        this.numPhysicalInputs = numPhysicalInputs;
        this.partitionNum = partitionNum;
        this.dagIdentifier = this.inputContext.getDagIdentifier();
        this.vertexIndex = this.inputContext.getTaskVertexIndex();
        this.reduceId = this.inputContext.getTaskIndex();
        LOG.info("RssTezFetcherTask, dagIdentifier:{}, vertexIndex:{}, reduceId:{}.", new Object[]{this.dagIdentifier, this.vertexIndex, this.reduceId});
        this.clientType = conf.get("tez.rss.client.type", "GRPC");
        this.storageType = conf.get("tez.rss.storage.type", "MEMORY_LOCALFILE");
        LOG.info("RssTezFetcherTask storageType:{}", (Object)this.storageType);
        this.basePath = this.conf.get("tez.rss.remote.storage.path");
        String remoteStorageConf = this.conf.get("tez.rss.remote.storage.conf");
        this.remoteStorageInfo = new RemoteStorageInfo(this.basePath, remoteStorageConf);
        String readBufferSize = conf.get("tez.rss.client.read.buffer.size", "14m");
        this.readBufferSize = (int)UnitConverter.byteStringAsBytes(readBufferSize);
        this.partitionNumPerRange = conf.getInt("tez.rss.partitionNum.per.range", 1);
        this.maxAttemptNo = maxAttemptNo;
        LOG.info("RssTezFetcherTask fetch partition:{}, with inputs:{}, readBufferSize:{}, partitionNumPerRange:{}.", new Object[]{this.partition, inputs, this.readBufferSize, this.partitionNumPerRange});
    }

    protected FetchResult callInternal() throws Exception {
        ShuffleWriteClient writeClient = RssTezUtils.createShuffleClient(this.conf);
        LOG.info("WriteClient getShuffleResult, clientType:{}, serverInfoSet:{}, appId:{}, shuffleId:{}, partition:{}", new Object[]{this.clientType, this.serverInfoSet, this.applicationAttemptId.toString(), this.shuffleId, this.partition});
        Roaring64NavigableMap blockIdBitmap = writeClient.getShuffleResult(this.clientType, this.serverInfoSet, this.applicationAttemptId.toString(), this.shuffleId, this.partition);
        writeClient.close();
        this.rssAllBlockIdBitmapMap.put(this.partition, blockIdBitmap);
        int appAttemptId = this.applicationAttemptId.getAttemptId();
        Roaring64NavigableMap taskIdBitmap = RssTezUtils.fetchAllRssTaskIds(new HashSet<InputAttemptIdentifier>(this.inputs), this.numPhysicalInputs, appAttemptId, this.maxAttemptNo);
        LOG.info("Inputs:{}, num input:{}, appAttemptId:{}, taskIdBitmap:{}", new Object[]{this.inputs, this.numPhysicalInputs, appAttemptId, taskIdBitmap});
        LOG.info("In reduce: " + this.reduceId + ", RSS Tez client has fetched blockIds and taskIds successfully");
        if (!taskIdBitmap.isEmpty()) {
            LOG.info("In reduce: " + this.reduceId + ", Rss Tez client starts to fetch blocks from RSS server");
            Configuration hadoopConf = this.getRemoteConf();
            LOG.info("RssTezFetcherTask storageType:{}", (Object)this.storageType);
            boolean expectedTaskIdsBitmapFilterEnable = this.serverInfoSet.size() > 1;
            ShuffleReadClient shuffleReadClient = ShuffleClientFactory.getInstance().createShuffleReadClient(ShuffleClientFactory.newReadBuilder().appId(this.applicationAttemptId.toString()).shuffleId(this.shuffleId).partitionId(this.partition).basePath(this.basePath).partitionNumPerRange(this.partitionNumPerRange).partitionNum(this.partitionNum).blockIdBitmap(blockIdBitmap).taskIdBitmap(taskIdBitmap).shuffleServerInfoList(new ArrayList<ShuffleServerInfo>(this.serverInfoSet)).hadoopConf(hadoopConf).idHelper(new TezIdHelper()).expectedTaskIdsBitmapFilterEnable(expectedTaskIdsBitmapFilterEnable).rssConf(RssTezConfig.toRssConf(this.conf)));
            RssTezFetcher fetcher = new RssTezFetcher(this.fetcherCallback, this.inputManager, shuffleReadClient, this.rssSuccessBlockIdBitmapMap, this.partition, RssTezConfig.toRssConf(this.conf));
            fetcher.fetchAllRssBlocks();
            LOG.info("In reduce: " + this.partition + ", Rss Tez client fetches blocks from RSS server successfully");
        }
        return null;
    }

    public void shutdown() {
    }

    private Configuration getRemoteConf() {
        Configuration remoteConf = new Configuration(this.conf);
        if (!this.remoteStorageInfo.isEmpty()) {
            for (Map.Entry<String, String> entry : this.remoteStorageInfo.getConfItems().entrySet()) {
                remoteConf.set(entry.getKey(), entry.getValue());
            }
        }
        return remoteConf;
    }

    public int getPartitionId() {
        return this.partition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RssTezFetcherTask that = (RssTezFetcherTask)((Object)o);
        return this.partition == that.partition && this.numPhysicalInputs == that.numPhysicalInputs && this.dagIdentifier == that.dagIdentifier && this.vertexIndex == that.vertexIndex && this.reduceId == that.reduceId && Objects.equals(this.applicationAttemptId.toString(), that.applicationAttemptId.toString());
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.numPhysicalInputs, this.dagIdentifier, this.vertexIndex, this.reduceId, this.applicationAttemptId.toString());
    }
}

