/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.art;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.roaringbitmap.art.Node;
import org.roaringbitmap.art.Node16;
import org.roaringbitmap.art.NodeType;
import org.roaringbitmap.art.SearchResult;
import org.roaringbitmap.longlong.IntegerUtil;
import org.roaringbitmap.longlong.LongUtils;

public class Node4
extends Node {
    int key = 0;
    Node[] children = new Node[4];

    public Node4(int compressedPrefixSize) {
        super(NodeType.NODE4, compressedPrefixSize);
    }

    @Override
    public int getChildPos(byte k) {
        for (int i = 0; i < this.count; ++i) {
            int shiftLeftLen = (3 - i) * 8;
            byte v = (byte)(this.key >> shiftLeftLen);
            if (v != k) continue;
            return i;
        }
        return -1;
    }

    @Override
    public SearchResult getNearestChildPos(byte k) {
        byte[] firstBytes = IntegerUtil.toBDBytes(this.key);
        return Node.binarySearchWithResult(firstBytes, 0, this.count, k);
    }

    @Override
    public byte getChildKey(int pos) {
        int shiftLeftLen = (3 - pos) * 8;
        byte v = (byte)(this.key >> shiftLeftLen);
        return v;
    }

    @Override
    public Node getChild(int pos) {
        return this.children[pos];
    }

    @Override
    public void replaceNode(int pos, Node freshOne) {
        this.children[pos] = freshOne;
    }

    @Override
    public int getMinPos() {
        return 0;
    }

    @Override
    public int getNextLargerPos(int pos) {
        if (pos == -1) {
            return 0;
        }
        return ++pos < this.count ? pos : -1;
    }

    @Override
    public int getMaxPos() {
        return this.count - 1;
    }

    @Override
    public int getNextSmallerPos(int pos) {
        if (pos == -1) {
            return this.count - 1;
        }
        return --pos >= 0 ? pos : -1;
    }

    public static Node insert(Node node, Node childNode, byte key) {
        Node4 current = (Node4)node;
        if (current.count < 4) {
            current.key = IntegerUtil.setByte(current.key, key, current.count);
            current.children[current.count] = childNode;
            current.count = (short)(current.count + 1);
            Node4.insertionSort(current);
            return current;
        }
        Node16 node16 = new Node16(current.prefixLength);
        node16.count = (short)4;
        node16.firstV = LongUtils.initWithFirst4Byte(current.key);
        System.arraycopy(current.children, 0, node16.children, 0, 4);
        Node4.copyPrefix(current, node16);
        Node freshOne = Node16.insert(node16, childNode, key);
        return freshOne;
    }

    @Override
    public Node remove(int pos) {
        assert (pos < this.count);
        this.children[pos] = null;
        this.count = (short)(this.count - 1);
        this.key = IntegerUtil.shiftLeftFromSpecifiedPosition(this.key, pos, 4 - pos - 1);
        while (pos < this.count) {
            this.children[pos] = this.children[pos + 1];
            ++pos;
        }
        if (this.count == 1) {
            Node child = this.children[0];
            byte newLength = (byte)(child.prefixLength + this.prefixLength + 1);
            byte[] newPrefix = new byte[newLength];
            System.arraycopy(this.prefix, 0, newPrefix, 0, this.prefixLength);
            newPrefix[this.prefixLength] = IntegerUtil.firstByte(this.key);
            System.arraycopy(child.prefix, 0, newPrefix, this.prefixLength + 1, child.prefixLength);
            child.prefixLength = newLength;
            child.prefix = newPrefix;
            return child;
        }
        return this;
    }

    @Override
    public void serializeNodeBody(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(Integer.reverseBytes(this.key));
    }

    @Override
    public void serializeNodeBody(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.putInt(this.key);
    }

    @Override
    public void deserializeNodeBody(DataInput dataInput) throws IOException {
        int v = dataInput.readInt();
        this.key = Integer.reverseBytes(v);
    }

    @Override
    public void deserializeNodeBody(ByteBuffer byteBuffer) throws IOException {
        this.key = byteBuffer.getInt();
    }

    @Override
    public int serializeNodeBodySizeInBytes() {
        return 4;
    }

    @Override
    public void replaceChildren(Node[] children) {
        int pos = this.getNextLargerPos(-1);
        int offset = 0;
        while (pos != -1) {
            this.children[pos] = children[offset];
            pos = this.getNextLargerPos(pos);
            ++offset;
        }
    }

    private static void insertionSort(Node4 node4) {
        node4.key = Node4.sortSmallByteArray(node4.key, node4.children, 0, node4.count - 1);
    }

    private static int sortSmallByteArray(int intKey, Node[] children, int left, int right) {
        int i;
        byte[] key = IntegerUtil.toBDBytes(intKey);
        int j = i = left;
        while (i < right) {
            byte ai = key[i + 1];
            Node child = children[i + 1];
            int unsignedByteAi = Byte.toUnsignedInt(ai);
            while (unsignedByteAi < Byte.toUnsignedInt(key[j])) {
                key[j + 1] = key[j];
                children[j + 1] = children[j];
                if (j-- != left) continue;
            }
            key[j + 1] = ai;
            children[j + 1] = child;
            j = ++i;
        }
        return IntegerUtil.fromBDBytes(key);
    }
}

