/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.common.netty.buffer.NettyManagedBuffer;
import org.apache.uniffle.common.netty.protocol.Decoders;
import org.apache.uniffle.common.netty.protocol.Encoders;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.netty.protocol.RpcResponse;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.ByteBufUtils;

public class GetMemoryShuffleDataResponse
extends RpcResponse {
    private List<BufferSegment> bufferSegments;

    public GetMemoryShuffleDataResponse(long requestId, StatusCode statusCode, List<BufferSegment> bufferSegments, byte[] data) {
        this(requestId, statusCode, null, bufferSegments, data);
    }

    public GetMemoryShuffleDataResponse(long requestId, StatusCode statusCode, String retMessage, List<BufferSegment> bufferSegments, byte[] data) {
        this(requestId, statusCode, retMessage, bufferSegments, Unpooled.wrappedBuffer((byte[])data));
    }

    public GetMemoryShuffleDataResponse(long requestId, StatusCode statusCode, String retMessage, List<BufferSegment> bufferSegments, ByteBuf data) {
        this(requestId, statusCode, retMessage, bufferSegments, new NettyManagedBuffer(data));
    }

    public GetMemoryShuffleDataResponse(long requestId, StatusCode statusCode, String retMessage, List<BufferSegment> bufferSegments, ManagedBuffer managedBuffer) {
        super(requestId, statusCode, retMessage, managedBuffer);
        this.bufferSegments = bufferSegments;
    }

    @Override
    public int encodedLength() {
        return super.encodedLength() + Encoders.encodeLengthOfBufferSegments(this.bufferSegments);
    }

    @Override
    public void encode(ByteBuf buf) {
        super.encode(buf);
        Encoders.encodeBufferSegments(this.bufferSegments, buf);
    }

    public static GetMemoryShuffleDataResponse decode(ByteBuf byteBuf, boolean decodeBody) {
        long requestId = byteBuf.readLong();
        StatusCode statusCode = StatusCode.fromCode(byteBuf.readInt());
        String retMessage = ByteBufUtils.readLengthAndString(byteBuf);
        List<BufferSegment> bufferSegments = Decoders.decodeBufferSegments(byteBuf);
        if (decodeBody) {
            NettyManagedBuffer nettyManagedBuffer = new NettyManagedBuffer(byteBuf);
            return new GetMemoryShuffleDataResponse(requestId, statusCode, retMessage, bufferSegments, nettyManagedBuffer);
        }
        return new GetMemoryShuffleDataResponse(requestId, statusCode, retMessage, bufferSegments, NettyManagedBuffer.EMPTY_BUFFER);
    }

    @Override
    public Message.Type type() {
        return Message.Type.GET_MEMORY_SHUFFLE_DATA_RESPONSE;
    }

    public List<BufferSegment> getBufferSegments() {
        return this.bufferSegments;
    }
}

