/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.conf;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.filesystem.HadoopFilesystemProvider;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.conf.ClientConf;
import org.apache.uniffle.coordinator.conf.ClientConfParser;
import org.apache.uniffle.coordinator.conf.LegacyClientConfParser;
import org.apache.uniffle.coordinator.conf.YamlClientConfParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicClientConfService
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicClientConfService.class);
    private Path confStoredPath;
    private FileSystem fileSystem;
    private ClientConfParser[] parsers;
    private final AtomicLong latestModificationMS = new AtomicLong(0L);
    private ScheduledExecutorService updateClientConfExecutor = null;
    private final Object clientConfLock = new Object();
    private ClientConf clientConf = null;
    private Consumer<ClientConf>[] callbacks;

    public DynamicClientConfService(CoordinatorConf coordinatorConf, Configuration hadoopConf) throws Exception {
        this(coordinatorConf, hadoopConf, new Consumer[0]);
    }

    public DynamicClientConfService(CoordinatorConf coordinatorConf, Configuration hadoopConf, Consumer<ClientConf>[] callbacks) throws Exception {
        ClientConfParser[] confParsers;
        if (!coordinatorConf.getBoolean(CoordinatorConf.COORDINATOR_DYNAMIC_CLIENT_CONF_ENABLED)) {
            return;
        }
        this.callbacks = callbacks;
        String clientConfStoredRawPath = coordinatorConf.getString(CoordinatorConf.COORDINATOR_DYNAMIC_CLIENT_CONF_PATH);
        this.confStoredPath = new Path(clientConfStoredRawPath);
        this.fileSystem = HadoopFilesystemProvider.getFilesystem((Path)this.confStoredPath, (Configuration)hadoopConf);
        ClientConfParser.Parser parserType = (ClientConfParser.Parser)((Object)coordinatorConf.get(CoordinatorConf.COORDINATOR_DYNAMIC_CLIENT_RAW_CONF_PARSER));
        switch (parserType) {
            case YAML: {
                confParsers = new ClientConfParser[]{new YamlClientConfParser()};
                break;
            }
            case LEGACY: {
                confParsers = new ClientConfParser[]{new LegacyClientConfParser()};
                break;
            }
            default: {
                confParsers = new ClientConfParser[]{new LegacyClientConfParser(), new YamlClientConfParser()};
            }
        }
        this.parsers = confParsers;
        if (!this.fileSystem.isFile(this.confStoredPath)) {
            String msg = String.format("Fail to init, %s is not a file.", this.confStoredPath.toUri());
            LOGGER.error(msg);
            throw new IllegalStateException(msg);
        }
        this.refreshClientConf();
        LOGGER.info("Load client conf from {} successfully", (Object)this.confStoredPath);
        int updateIntervalSec = coordinatorConf.getInteger(CoordinatorConf.COORDINATOR_DYNAMIC_CLIENT_CONF_UPDATE_INTERVAL_SEC);
        this.updateClientConfExecutor = ThreadUtils.getDaemonSingleThreadScheduledExecutor((String)this.getClass().getSimpleName());
        this.updateClientConfExecutor.scheduleAtFixedRate(this::refreshClientConf, 0L, updateIntervalSec, TimeUnit.SECONDS);
    }

    private void refreshClientConf() {
        try {
            Object[] fileStatus = this.fileSystem.listStatus(this.confStoredPath);
            if (ArrayUtils.isNotEmpty((Object[])fileStatus)) {
                long modifiedMS = fileStatus[0].getModificationTime();
                if (this.latestModificationMS.get() != modifiedMS) {
                    this.doRefreshClientConf();
                    this.latestModificationMS.set(modifiedMS);
                    Arrays.stream(this.callbacks).forEach(x -> x.accept(this.clientConf));
                    LOGGER.info("Update client conf from {} successfully.", (Object)this.confStoredPath);
                }
            } else {
                LOGGER.warn("Client conf file not found with {}", (Object)this.confStoredPath);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error when update client conf with {}.", (Object)this.confStoredPath, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doRefreshClientConf() throws Exception {
        try {
            Throwable throwable = null;
            try (FSDataInputStream in = this.fileSystem.open(this.confStoredPath);){
                for (ClientConfParser parser : this.parsers) {
                    try {
                        ClientConf conf = parser.tryParse((InputStream)in);
                        Object object = this.clientConfLock;
                        synchronized (object) {
                            this.clientConf = conf;
                            return;
                        }
                    }
                    catch (Exception exception) {
                        try {
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                            throw new Exception("Unknown format of clientConf file.");
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Fail to refresh client conf from {}", (Object)this.confStoredPath.toUri().toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getRssClientConf() {
        Object object = this.clientConfLock;
        synchronized (object) {
            return this.clientConf.getRssClientConf();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, RemoteStorageInfo> listRemoteStorageInfos() {
        Object object = this.clientConfLock;
        synchronized (object) {
            return this.clientConf.getRemoteStorageInfos();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.updateClientConfExecutor != null) {
            this.updateClientConfExecutor.shutdownNow();
        }
    }
}

