/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shaded.guava.graph;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.uniffle.shaded.guava.collect.BiMap;
import org.apache.uniffle.shaded.guava.collect.HashBiMap;
import org.apache.uniffle.shaded.guava.collect.ImmutableBiMap;
import org.apache.uniffle.shaded.guava.graph.AbstractUndirectedNetworkConnections;
import org.apache.uniffle.shaded.guava.graph.EdgesConnecting;
import org.apache.uniffle.shaded.guava.graph.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
final class UndirectedNetworkConnections<N, E>
extends AbstractUndirectedNetworkConnections<N, E> {
    UndirectedNetworkConnections(Map<E, N> incidentEdgeMap) {
        super(incidentEdgeMap);
    }

    static <N, E> UndirectedNetworkConnections<N, E> of() {
        return new UndirectedNetworkConnections(HashBiMap.create(2));
    }

    static <N, E> UndirectedNetworkConnections<N, E> ofImmutable(Map<E, N> incidentEdges) {
        return new UndirectedNetworkConnections<N, E>(ImmutableBiMap.copyOf(incidentEdges));
    }

    @Override
    public Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(((BiMap)this.incidentEdgeMap).values());
    }

    @Override
    public Set<E> edgesConnecting(N node) {
        return new EdgesConnecting(((BiMap)this.incidentEdgeMap).inverse(), node);
    }
}

