/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client;

import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.uniffle.client.HttpClientFactory;
import org.apache.uniffle.client.RestClient;
import org.apache.uniffle.client.RestClientConf;
import org.apache.uniffle.client.RestClientImpl;

public class UniffleRestClient
implements AutoCloseable {
    private RestClient restClient;
    private RestClientConf conf;
    private String hostUrl;

    @Override
    public void close() throws Exception {
        if (this.restClient != null) {
            this.restClient.close();
        }
    }

    private UniffleRestClient(Builder builder) {
        this.hostUrl = builder.hostUrl;
        RestClientConf conf = new RestClientConf();
        conf.setConnectTimeout(builder.connectTimeout);
        conf.setSocketTimeout(builder.socketTimeout);
        conf.setMaxAttempts(builder.maxAttempts);
        conf.setAttemptWaitTime(builder.attemptWaitTime);
        this.conf = conf;
        CloseableHttpClient httpclient = HttpClientFactory.createHttpClient(conf);
        this.restClient = new RestClientImpl(this.hostUrl, httpclient);
    }

    public RestClient getHttpClient() {
        return this.restClient;
    }

    public RestClientConf getConf() {
        return this.conf;
    }

    public static Builder builder(String hostUrl) {
        return new Builder(hostUrl);
    }

    public static class Builder {
        private String hostUrl;
        private int socketTimeout = 120000;
        private int connectTimeout = 30000;
        private int maxAttempts = 3;
        private int attemptWaitTime = 3000;

        public Builder(String hostUrl) {
            this.hostUrl = hostUrl;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder connectionTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder attemptWaitTime(int attemptWaitTime) {
            this.attemptWaitTime = attemptWaitTime;
            return this;
        }

        public UniffleRestClient build() {
            return new UniffleRestClient(this);
        }
    }
}

