/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.storage.common.FileBasedShuffleSegment;
import org.apache.uniffle.storage.handler.api.ShuffleWriteHandler;
import org.apache.uniffle.storage.handler.impl.LocalFileWriter;
import org.apache.uniffle.storage.util.ShuffleStorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileWriteHandler
implements ShuffleWriteHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileWriteHandler.class);
    private String fileNamePrefix;
    private String basePath;

    public LocalFileWriteHandler(String appId, int shuffleId, int startPartition, int endPartition, String storageBasePath, String fileNamePrefix) {
        this.fileNamePrefix = fileNamePrefix;
        this.basePath = ShuffleStorageUtils.getFullShuffleDataFolder(storageBasePath, ShuffleStorageUtils.getShuffleDataPath(appId, shuffleId, startPartition, endPartition));
        this.createBasePath();
    }

    private void createBasePath() {
        File baseFolder = new File(this.basePath);
        if (baseFolder.isDirectory()) {
            return;
        }
        try {
            Files.createDirectories(baseFolder.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RssException("Failed to create shuffle folder: " + this.basePath, (Throwable)e);
        }
    }

    private String pickBasePath(String[] storageBasePaths, String appId, int shuffleId, int startPartition) {
        if (storageBasePaths == null || storageBasePaths.length == 0) {
            throw new RssException("Base path can't be empty, please check rss.storage.localFile.basePaths");
        }
        int index = ShuffleStorageUtils.getStorageIndex(storageBasePaths.length, appId, shuffleId, startPartition);
        return storageBasePaths[index];
    }

    @Override
    public synchronized void write(List<ShufflePartitionedBlock> shuffleBlocks) throws Exception {
        File baseFolder = new File(this.basePath);
        if (!baseFolder.exists()) {
            LOG.warn("{} don't exist, the app or shuffle may be deleted", (Object)baseFolder.getAbsolutePath());
            return;
        }
        long accessTime = System.currentTimeMillis();
        String dataFileName = ShuffleStorageUtils.generateDataFileName(this.fileNamePrefix);
        String indexFileName = ShuffleStorageUtils.generateIndexFileName(this.fileNamePrefix);
        try (LocalFileWriter dataWriter = this.createWriter(dataFileName);
             LocalFileWriter indexWriter = this.createWriter(indexFileName);){
            long startTime = System.currentTimeMillis();
            for (ShufflePartitionedBlock block : shuffleBlocks) {
                long blockId = block.getBlockId();
                long crc = block.getCrc();
                long startOffset = dataWriter.nextOffset();
                dataWriter.writeData(ByteBufUtils.readBytes((ByteBuf)block.getData()));
                FileBasedShuffleSegment segment = new FileBasedShuffleSegment(blockId, startOffset, block.getLength(), block.getUncompressLength(), crc, block.getTaskAttemptId());
                indexWriter.writeIndex(segment);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Write handler write {} blocks cost {} ms without file open close", (Object)shuffleBlocks.size(), (Object)(System.currentTimeMillis() - startTime));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Write handler write {} blocks cost {} ms with file open close", (Object)shuffleBlocks.size(), (Object)(System.currentTimeMillis() - accessTime));
        }
    }

    private LocalFileWriter createWriter(String fileName) throws IOException, IllegalStateException {
        File file = new File(this.basePath, fileName);
        return new LocalFileWriter(file);
    }

    @VisibleForTesting
    protected String getBasePath() {
        return this.basePath;
    }
}

