/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import io.grpc.stub.StreamObserver;
import org.apache.uniffle.common.exception.InvalidRequestException;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.proto.ShuffleServerInternalGrpc;
import org.apache.uniffle.server.ShuffleServer;

public class ShuffleServerInternalGrpcService
extends ShuffleServerInternalGrpc.ShuffleServerInternalImplBase {
    private final ShuffleServer shuffleServer;

    public ShuffleServerInternalGrpcService(ShuffleServer shuffleServer) {
        this.shuffleServer = shuffleServer;
    }

    public void decommission(RssProtos.DecommissionRequest request, StreamObserver<RssProtos.DecommissionResponse> responseObserver) {
        RssProtos.DecommissionResponse response;
        try {
            this.shuffleServer.decommission();
            response = RssProtos.DecommissionResponse.newBuilder().setStatus(StatusCode.SUCCESS.toProto()).build();
        }
        catch (Exception e) {
            StatusCode statusCode = StatusCode.INTERNAL_ERROR;
            if (e instanceof InvalidRequestException) {
                statusCode = StatusCode.INVALID_REQUEST;
            }
            response = RssProtos.DecommissionResponse.newBuilder().setStatus(statusCode.toProto()).setRetMsg(e.getMessage()).build();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void cancelDecommission(RssProtos.CancelDecommissionRequest request, StreamObserver<RssProtos.CancelDecommissionResponse> responseObserver) {
        RssProtos.CancelDecommissionResponse response;
        try {
            this.shuffleServer.cancelDecommission();
            response = RssProtos.CancelDecommissionResponse.newBuilder().setStatus(StatusCode.SUCCESS.toProto()).build();
        }
        catch (Exception e) {
            StatusCode statusCode = StatusCode.INTERNAL_ERROR;
            if (e instanceof InvalidRequestException) {
                statusCode = StatusCode.INVALID_REQUEST;
            }
            response = RssProtos.CancelDecommissionResponse.newBuilder().setStatus(statusCode.toProto()).setRetMsg(e.getMessage()).build();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }
}

