/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.storage;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.apache.uniffle.server.storage.StorageManager;
import org.apache.uniffle.shaded.guava.collect.Lists;
import org.apache.uniffle.shaded.guava.util.concurrent.Uninterruptibles;
import org.apache.uniffle.storage.common.Storage;
import org.apache.uniffle.storage.common.StorageWriteMetrics;
import org.apache.uniffle.storage.handler.api.ShuffleWriteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SingleStorageManager
implements StorageManager {
    private static final Logger LOG = LoggerFactory.getLogger(SingleStorageManager.class);
    private final long writeSlowThreshold;
    private final long eventSizeThresholdL1;
    private final long eventSizeThresholdL2;
    private final long eventSizeThresholdL3;

    public SingleStorageManager(ShuffleServerConf conf) {
        this.writeSlowThreshold = conf.getSizeAsBytes(ShuffleServerConf.SERVER_WRITE_SLOW_THRESHOLD);
        this.eventSizeThresholdL1 = conf.getSizeAsBytes(ShuffleServerConf.SERVER_EVENT_SIZE_THRESHOLD_L1);
        this.eventSizeThresholdL2 = conf.getSizeAsBytes(ShuffleServerConf.SERVER_EVENT_SIZE_THRESHOLD_L2);
        this.eventSizeThresholdL3 = conf.getSizeAsBytes(ShuffleServerConf.SERVER_EVENT_SIZE_THRESHOLD_L3);
    }

    @Override
    public boolean write(Storage storage, ShuffleWriteHandler handler, ShuffleDataFlushEvent event) {
        String shuffleKey = RssUtils.generateShuffleKey((String)event.getAppId(), (int)event.getShuffleId());
        storage.createMetadataIfNotExist(shuffleKey);
        try {
            long startWrite = System.currentTimeMillis();
            handler.write(event.getShuffleBlocks());
            long writeTime = System.currentTimeMillis() - startWrite;
            this.updateWriteMetrics(event, writeTime);
            return true;
        }
        catch (Exception e) {
            LOG.warn("Exception happened when write data for " + event + ", try again", (Throwable)e);
            ShuffleServerMetrics.counterWriteException.inc();
            Uninterruptibles.sleepUninterruptibly(1000L, TimeUnit.MILLISECONDS);
            return false;
        }
    }

    @Override
    public void updateWriteMetrics(ShuffleDataFlushEvent event, long writeTime) {
        try {
            StorageWriteMetrics metrics = this.createStorageWriteMetrics(event, writeTime);
            ShuffleServerMetrics.counterTotalWriteTime.inc((double)metrics.getWriteTime());
            ShuffleServerMetrics.counterWriteTotal.inc();
            if (metrics.getWriteTime() > this.writeSlowThreshold) {
                ShuffleServerMetrics.counterWriteSlow.inc();
            }
            ShuffleServerMetrics.counterTotalWriteDataSize.inc((double)metrics.getEventSize());
            ShuffleServerMetrics.counterTotalWriteBlockSize.inc((double)metrics.getWriteBlocks());
            if (metrics.getEventSize() < this.eventSizeThresholdL1) {
                ShuffleServerMetrics.counterEventSizeThresholdLevel1.inc();
            } else if (metrics.getEventSize() < this.eventSizeThresholdL2) {
                ShuffleServerMetrics.counterEventSizeThresholdLevel2.inc();
            } else if (metrics.getEventSize() < this.eventSizeThresholdL3) {
                ShuffleServerMetrics.counterEventSizeThresholdLevel3.inc();
            } else {
                ShuffleServerMetrics.counterEventSizeThresholdLevel4.inc();
            }
            Storage storage = event.getUnderStorage();
            if (storage != null) {
                storage.updateWriteMetrics(metrics);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception happened when update write metrics for " + event, (Throwable)e);
        }
    }

    @Override
    public boolean canWrite(ShuffleDataFlushEvent event) {
        try {
            Storage storage = this.selectStorage(event);
            return storage != null && storage.canWrite();
        }
        catch (Exception e) {
            LOG.warn("Exception happened when select storage", (Throwable)e);
            return false;
        }
    }

    public StorageWriteMetrics createStorageWriteMetrics(ShuffleDataFlushEvent event, long writeTime) {
        long length = 0L;
        long blockNum = 0L;
        for (ShufflePartitionedBlock block : event.getShuffleBlocks()) {
            length += (long)block.getLength();
            ++blockNum;
        }
        ArrayList<Integer> partitions = Lists.newArrayList();
        for (int partition = event.getStartPartition(); partition <= event.getEndPartition(); ++partition) {
            partitions.add(partition);
        }
        return new StorageWriteMetrics(event.getSize(), blockNum, writeTime, length, partitions, event.getAppId(), event.getShuffleId());
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

