/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j2.internal.spi;

import org.apache.logging.log4j.Level;
import org.ops4j.pax.logging.spi.PaxLevel;

public class PaxLevelImpl
implements PaxLevel {
    public static final int SYSLOG_ALL = 7;
    public static final int SYSLOG_TRACE = 7;
    public static final int SYSLOG_DEBUG = 7;
    public static final int SYSLOG_INFO = 6;
    public static final int SYSLOG_WARN = 4;
    public static final int SYSLOG_ERROR = 3;
    public static final int SYSLOG_FATAL = 0;
    public static final int SYSLOG_OFF = 0;
    private final Level level;

    public PaxLevelImpl(Level level) {
        this.level = level;
    }

    public boolean isGreaterOrEqual(PaxLevel r) {
        return this.getSyslogEquivalent() <= r.getSyslogEquivalent();
    }

    public int toInt() {
        int lvl = this.level.intLevel();
        if (lvl <= Level.ERROR.intLevel()) {
            return 4;
        }
        if (lvl <= Level.WARN.intLevel()) {
            return 3;
        }
        if (lvl <= Level.INFO.intLevel()) {
            return 2;
        }
        if (lvl <= Level.DEBUG.intLevel()) {
            return 1;
        }
        return 0;
    }

    public int getSyslogEquivalent() {
        int lvl = this.level.intLevel();
        if (lvl <= Level.OFF.intLevel()) {
            return 0;
        }
        if (lvl <= Level.ERROR.intLevel()) {
            return 3;
        }
        if (lvl <= Level.WARN.intLevel()) {
            return 4;
        }
        if (lvl <= Level.INFO.intLevel()) {
            return 6;
        }
        if (lvl <= Level.DEBUG.intLevel()) {
            return 7;
        }
        if (lvl <= Level.ALL.intLevel()) {
            return 7;
        }
        return 7;
    }

    public String toString() {
        return this.level.toString();
    }
}

