/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.web.internal.osgi;

import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.apache.karaf.web.WebContainerService;
import org.apache.karaf.web.internal.WebContainerServiceImpl;
import org.apache.karaf.web.internal.WebEventHandler;
import org.apache.karaf.web.management.internal.WebMBeanImpl;
import org.ops4j.pax.web.service.spi.WarManager;
import org.ops4j.pax.web.service.spi.WebListener;
import org.osgi.framework.BundleListener;

@Services(requires={@RequireService(value=WarManager.class)}, provides={@ProvideService(value=WebContainerService.class)})
public class Activator
extends BaseActivator {
    private WebContainerServiceImpl webContainerService;

    @Override
    protected void doStart() throws Exception {
        WarManager warManager = this.getTrackedService(WarManager.class);
        if (warManager == null) {
            return;
        }
        WebEventHandler webEventHandler = new WebEventHandler();
        this.register(WebListener.class, webEventHandler);
        this.webContainerService = new WebContainerServiceImpl();
        this.bundleContext.addBundleListener((BundleListener)this.webContainerService);
        this.webContainerService.setBundleContext(this.bundleContext);
        this.webContainerService.setWarManager(warManager);
        this.webContainerService.setWebEventHandler(webEventHandler);
        this.register(WebContainerService.class, this.webContainerService);
        WebMBeanImpl webMBean = new WebMBeanImpl();
        webMBean.setWebContainerService(this.webContainerService);
        this.registerMBean(webMBean, "type=web");
    }

    @Override
    protected void doStop() {
        if (this.webContainerService != null) {
            this.bundleContext.removeBundleListener((BundleListener)this.webContainerService);
            this.webContainerService = null;
        }
        super.doStop();
    }
}

