/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.indexer.analyzers;

import aQute.bnd.header.Parameters;
import aQute.bnd.indexer.ResourceAnalyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.version.Version;
import aQute.bnd.version.VersionRange;
import aQute.libg.glob.Glob;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.resource.Requirement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SCRAnalyzer
implements ResourceAnalyzer {
    public static final String NS_1_0 = "http://www.osgi.org/xmlns/scr/v1.0.0";
    public static final String NS_1_1 = "http://www.osgi.org/xmlns/scr/v1.1.0";
    public static final String NS_1_2 = "http://www.osgi.org/xmlns/scr/v1.2.0";

    public void analyzeResource(Jar resource, ResourceBuilder rb) throws Exception {
        String header = resource.getManifest().getMainAttributes().getValue("Service-Component");
        if (header == null) {
            return;
        }
        Parameters parameters = new Parameters(header);
        Version highest = null;
        for (String pattern : parameters.keySet()) {
            Glob glob = new Glob(pattern);
            for (String path : resource.getResources().keySet()) {
                Version version;
                if (!glob.matcher(path).matches() || (version = this.processScrXml(resource.getResource(path), path)) == null || highest != null && version.compareTo(highest) <= 0) continue;
                highest = version;
            }
        }
        if (highest != null) {
            Version lower = new Version(highest.getMajor(), highest.getMinor(), 0);
            Version upper = new Version(highest.getMajor() + 1, 0, 0);
            Requirement requirement = SCRAnalyzer.createRequirement(new VersionRange(true, lower, upper, false));
            rb.addRequirement(requirement);
        }
    }

    private Version processScrXml(Resource resource, String path) throws Exception {
        if (resource == null) {
            return null;
        }
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser parser = spf.newSAXParser();
        SCRContentHandler handler = new SCRContentHandler();
        parser.parse(resource.openInputStream(), (DefaultHandler)handler);
        return handler.highest;
    }

    private static Requirement createRequirement(VersionRange range) {
        CapReqBuilder builder = new CapReqBuilder("osgi.extender");
        StringBuilder filter = new StringBuilder();
        filter.append('(').append("osgi.extender").append('=').append("osgi.ds").append(')');
        filter.insert(0, "(&");
        filter.append(range.toFilter());
        filter.append(')');
        builder.addDirective("filter", filter.toString()).addDirective("effective", "active");
        Requirement requirement = builder.buildRequirement();
        return requirement;
    }

    private static class SCRContentHandler
    extends DefaultHandler {
        Version highest = null;
        private boolean beforeRoot = true;

        public void startElement(String uri, String localName, String qName, Attributes attribs) throws SAXException {
            if (uri == null || "".equals(uri)) {
                if (this.beforeRoot) {
                    this.beforeRoot = false;
                    this.setVersion(new Version(1, 0, 0));
                }
            } else if (SCRAnalyzer.NS_1_2.equals(uri)) {
                this.setVersion(new Version(1, 2, 0));
            } else if (SCRAnalyzer.NS_1_1.equals(uri)) {
                this.setVersion(new Version(1, 1, 0));
            } else if (SCRAnalyzer.NS_1_0.equals(uri)) {
                this.setVersion(new Version(1, 0, 0));
            }
        }

        private void setVersion(Version version) {
            if (this.highest == null || version.compareTo(this.highest) > 0) {
                this.highest = version;
            }
        }
    }
}

