/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.WriteResource;
import aQute.lib.io.IO;
import aQute.lib.tag.Tag;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PomResource
extends WriteResource {
    final Manifest manifest;
    private Map<String, String> scm;
    static final Pattern NAME_URL = Pattern.compile("(.*)(http://.*)");

    public PomResource(Manifest manifest) {
        this.manifest = manifest;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(OutputStream out) throws IOException {
        PrintWriter ps = IO.writer(out);
        String name = this.manifest.getMainAttributes().getValue("Bundle-Name");
        String description = this.manifest.getMainAttributes().getValue("Bundle-Description");
        String docUrl = this.manifest.getMainAttributes().getValue("Bundle-DocURL");
        String version = this.manifest.getMainAttributes().getValue("Bundle-Version");
        String bundleVendor = this.manifest.getMainAttributes().getValue("Bundle-Vendor");
        String bsn = this.manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        String licenses = this.manifest.getMainAttributes().getValue("Bundle-License");
        if (bsn == null) {
            throw new RuntimeException("Cannot create POM unless bsn is set");
        }
        int n = (bsn = bsn.trim()).lastIndexOf(46);
        if (n <= 0) {
            throw new RuntimeException("Can not create POM unless Bundle-SymbolicName contains a . to separate group and  artifact id");
        }
        if (version == null) {
            version = "0";
        }
        String groupId = bsn.substring(0, n);
        String artifactId = bsn.substring(n + 1);
        if ((n = artifactId.indexOf(59)) > 0) {
            artifactId = artifactId.substring(0, n).trim();
        }
        Tag project = new Tag("project", new Object[0]);
        project.addAttribute("xmlns", "http://maven.apache.org/POM/4.0.0");
        project.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        project.addAttribute("xmlns:xsi", "");
        project.addAttribute("xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd");
        project.addContent(new Tag("modelVersion", new Object[0]).addContent("4.0.0"));
        project.addContent(new Tag("groupId", new Object[0]).addContent(groupId));
        project.addContent(new Tag("artifactId", new Object[0]).addContent(artifactId));
        project.addContent(new Tag("version", new Object[0]).addContent(version));
        if (description != null) {
            new Tag(project, "description", new Object[0]).addContent(description);
        }
        if (name != null) {
            new Tag(project, "name", new Object[0]).addContent(name);
        }
        if (docUrl != null) {
            new Tag(project, "url", new Object[0]).addContent(docUrl);
        }
        if (this.scm != null) {
            Tag scm = new Tag(project, "scm", new Object[0]);
            for (Map.Entry<String, String> entry : this.scm.entrySet()) {
                new Tag(scm, entry.getKey(), new Object[0]).addContent(entry.getValue());
            }
        }
        if (bundleVendor != null) {
            void var16_19;
            Matcher m = NAME_URL.matcher(bundleVendor);
            String namePart = bundleVendor;
            Object var16_17 = null;
            if (m.matches()) {
                namePart = m.group(1);
                String string = m.group(2);
            }
            Tag tag = new Tag(project, "organization", new Object[0]);
            new Tag(tag, "name", new Object[0]).addContent(namePart.trim());
            if (var16_19 != null) {
                new Tag(tag, "url", new Object[0]).addContent(var16_19.trim());
            }
        }
        if (licenses != null) {
            Tag ls = new Tag(project, "licenses", new Object[0]);
            Parameters map = Processor.parseHeader(licenses, null);
            for (Map.Entry<String, Attrs> entry : map.entrySet()) {
                Tag l = new Tag(ls, "license", new Object[0]);
                Map values = entry.getValue();
                String url = entry.getKey();
                if (values.containsKey("description")) {
                    this.tagFromMap(l, values, "description", "name", url);
                } else {
                    this.tagFromMap(l, values, "name", "name", url);
                }
                this.tagFromMap(l, values, "url", "url", url);
                this.tagFromMap(l, values, "distribution", "distribution", "repo");
            }
        }
        project.print(0, ps);
        ps.flush();
    }

    private Tag tagFromMap(Tag parent, Map<String, String> values, String string, String tag, String object) {
        String value = values.get(string);
        if (value == null) {
            value = object;
        }
        if (value == null) {
            return parent;
        }
        new Tag(parent, tag, new Object[0]).addContent(value.trim());
        return parent;
    }

    public void setProperties(Map<String, String> scm) {
        this.scm = scm;
    }
}

