/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.segments.Segment;
import org.apache.unomi.api.services.SegmentService;
import org.apache.unomi.persistence.spi.CustomObjectMapper;

@Command(scope="unomi", name="segment-view", description="This will allows to view a segment in the Apache Unomi Context Server")
@Service
public class SegmentView
implements Action {
    @Reference
    SegmentService segmentService;
    @Argument(index=0, name="segmentId", description="The identifier for the segment", required=true, multiValued=false)
    String segmentIdentifier;

    public Object execute() throws Exception {
        Segment segment = this.segmentService.getSegmentDefinition(this.segmentIdentifier);
        if (segment == null) {
            System.out.println("Couldn't find a segment with id=" + this.segmentIdentifier);
            return null;
        }
        String jsonRule = CustomObjectMapper.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)segment);
        System.out.println(jsonRule);
        return null;
    }
}

