/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.bundle;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.karaf.cellar.bundle.BundleState;
import org.apache.karaf.cellar.bundle.BundleSupport;
import org.apache.karaf.cellar.bundle.ClusterBundleEvent;
import org.apache.karaf.cellar.core.control.BasicSwitch;
import org.apache.karaf.cellar.core.control.Switch;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.EventHandler;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.features.Feature;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.cm.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleEventHandler
extends BundleSupport
implements EventHandler<ClusterBundleEvent> {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(BundleEventHandler.class);
    public static final String SWITCH_ID = "org.apache.karaf.cellar.bundle.handler";
    private final Switch eventSwitch = new BasicSwitch("org.apache.karaf.cellar.bundle.handler");

    public void handle(ClusterBundleEvent event) {
        if (this.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            LOGGER.debug("CELLAR BUNDLE: {} switch is OFF, cluster event is not handled", (Object)SWITCH_ID);
            return;
        }
        if (this.groupManager == null) {
            LOGGER.error("CELLAR BUNDLE: retrieved event {} while groupManager is not available yet!", (Object)event);
            return;
        }
        if (!this.groupManager.isLocalGroup(event.getSourceGroup().getName())) {
            LOGGER.debug("CELLAR BUNDLE: node is not part of the event cluster group {}", (Object)event.getSourceGroup().getName());
            return;
        }
        try {
            if (event.getLocal() != null && event.getLocal().getId().equalsIgnoreCase(this.clusterManager.getNode().getId())) {
                LOGGER.trace("CELLAR BUNDLE: cluster event is local (coming from local synchronizer or listener)");
                return;
            }
            if (this.isAllowed(event.getSourceGroup(), "bundle", event.getLocation(), EventType.INBOUND).booleanValue()) {
                List<Feature> matchingFeatures = this.retrieveFeature(event.getLocation());
                for (Feature feature : matchingFeatures) {
                    if (this.isAllowed(event.getSourceGroup(), "feature", feature.getName(), EventType.INBOUND).booleanValue()) continue;
                    LOGGER.trace("CELLAR BUNDLE: bundle {} is contained in feature {} marked BLOCKED INBOUND for cluster group {}", new Object[]{event.getLocation(), feature.getName(), event.getSourceGroup().getName()});
                    return;
                }
                if (event.getType() == 2) {
                    this.installBundleFromLocation(event.getLocation(), event.getStartLevel());
                    LOGGER.debug("CELLAR BUNDLE: installing {}/{}", (Object)event.getSymbolicName(), (Object)event.getVersion());
                } else if (event.getType() == 1) {
                    this.uninstallBundle(event.getSymbolicName(), event.getVersion());
                    LOGGER.debug("CELLAR BUNDLE: uninstalling {}/{}", (Object)event.getSymbolicName(), (Object)event.getVersion());
                } else if (event.getType() == 32) {
                    if (!this.isInstalled(event.getLocation())) {
                        this.installBundleFromLocation(event.getLocation(), event.getStartLevel());
                    }
                    try {
                        this.startBundle(event.getSymbolicName(), event.getVersion());
                        LOGGER.debug("CELLAR BUNDLE: starting {}/{}", (Object)event.getSymbolicName(), (Object)event.getVersion());
                    }
                    catch (Exception e) {
                        Map clusterBundles = this.clusterManager.getMap("org.apache.karaf.cellar.bundle.map." + event.getSourceGroup().getName());
                        BundleState state = (BundleState)clusterBundles.get(event.getSymbolicName() + "/" + event.getVersion());
                        if (state != null) {
                            state.setStatus(2);
                            clusterBundles.put(event.getSymbolicName() + "/" + event.getVersion(), state);
                        }
                    }
                } else if (event.getType() == 4) {
                    Bundle b;
                    if (!this.isInstalled(event.getLocation())) {
                        this.installBundleFromLocation(event.getLocation(), event.getStartLevel());
                        LOGGER.debug("CELLAR BUNDLE: installing {}/{}", (Object)event.getSymbolicName(), (Object)event.getVersion());
                    }
                    if ((b = this.findBundle(event.getLocation())) != null) {
                        if (b.getState() == 32) {
                            LOGGER.debug("CELLAR BUNDLE: stopping bundle {}/{} on node", (Object)event.getSymbolicName(), (Object)event.getVersion());
                            this.stopBundle(event.getSymbolicName(), event.getVersion());
                        } else if (b.getState() == 2) {
                            LOGGER.debug("CELLAR BUNDLE: resolving bundle {}/{} on node", (Object)event.getSymbolicName(), (Object)event.getVersion());
                            ((FrameworkWiring)this.getBundleContext().getBundle(0L).adapt(FrameworkWiring.class)).resolveBundles(Collections.singleton(b));
                        }
                    } else {
                        LOGGER.warn("CELLAR BUNDLE: unable to find bundle located {} on node", (Object)event.getLocation());
                    }
                } else if (event.getType() == 555) {
                    this.updateBundle(event.getSymbolicName(), event.getVersion(), event.getLocation());
                }
            } else {
                LOGGER.trace("CELLAR BUNDLE: bundle {} is marked BLOCKED INBOUND for cluster group {}", (Object)event.getSymbolicName(), (Object)event.getSourceGroup().getName());
            }
        }
        catch (BundleException e) {
            LOGGER.error("CELLAR BUNDLE: failed to install bundle {}/{}.", (Object)new Object[]{event.getSymbolicName(), event.getVersion()}, (Object)e);
        }
        catch (Exception e) {
            LOGGER.error("CELLAR BUNDLE: failed to handle bundle event", (Throwable)e);
        }
    }

    public void init() {
    }

    public void destroy() {
    }

    public Switch getSwitch() {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
            if (configuration != null) {
                Boolean status = new Boolean((String)configuration.getProperties().get("handler." + ((Object)((Object)this)).getClass().getName()));
                if (status.booleanValue()) {
                    this.eventSwitch.turnOn();
                } else {
                    this.eventSwitch.turnOff();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.eventSwitch;
    }

    public Class<ClusterBundleEvent> getType() {
        return ClusterBundleEvent.class;
    }
}

