/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.service.command;

import java.util.concurrent.TimeoutException;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

@Command(scope="service", name="wait", description="Wait for a given OSGi service.")
@Service
public class Wait
implements Action {
    @Option(name="-e", aliases={"--exception"}, description="throw an exception if the service is not found after the timeout")
    boolean exception;
    @Option(name="-t", aliases={"--timeout"}, description="timeout to wait for the service (in milliseconds, negative to not wait at all, zero to wait forever)")
    long timeout = 0L;
    @Argument(name="service", description="The service class or filter", required=true, multiValued=false)
    String service;
    @Reference
    BundleContext bundleContext;

    public Object execute() throws Exception {
        try (ServiceTracker tracker = null;){
            String filter = this.service;
            if (!filter.startsWith("(")) {
                if (!filter.contains("=")) {
                    filter = "objectClass=" + filter;
                }
                filter = "(" + filter + ")";
            }
            Filter osgiFilter = FrameworkUtil.createFilter((String)filter);
            tracker = new ServiceTracker(this.bundleContext, osgiFilter, null);
            tracker.open(true);
            Object svc = tracker.getService();
            if (this.timeout >= 0L) {
                svc = tracker.waitForService(this.timeout);
            }
            if (this.exception && svc == null) {
                throw new TimeoutException("Can not find service '" + this.service + "' in the OSGi registry");
            }
            Boolean bl = svc != null;
            return bl;
        }
    }
}

