/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl.asn1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.apache.commons.ssl.asn1.ASN1EncodableVector;
import org.apache.commons.ssl.asn1.BERConstructedOctetString;
import org.apache.commons.ssl.asn1.BERNull;
import org.apache.commons.ssl.asn1.BERSequence;
import org.apache.commons.ssl.asn1.BERSet;
import org.apache.commons.ssl.asn1.BERTaggedObject;
import org.apache.commons.ssl.asn1.DERApplicationSpecific;
import org.apache.commons.ssl.asn1.DERBMPString;
import org.apache.commons.ssl.asn1.DERBitString;
import org.apache.commons.ssl.asn1.DERBoolean;
import org.apache.commons.ssl.asn1.DEREnumerated;
import org.apache.commons.ssl.asn1.DERGeneralString;
import org.apache.commons.ssl.asn1.DERGeneralizedTime;
import org.apache.commons.ssl.asn1.DERIA5String;
import org.apache.commons.ssl.asn1.DERInteger;
import org.apache.commons.ssl.asn1.DERNull;
import org.apache.commons.ssl.asn1.DERNumericString;
import org.apache.commons.ssl.asn1.DERObject;
import org.apache.commons.ssl.asn1.DERObjectIdentifier;
import org.apache.commons.ssl.asn1.DEROctetString;
import org.apache.commons.ssl.asn1.DEROutputStream;
import org.apache.commons.ssl.asn1.DERPrintableString;
import org.apache.commons.ssl.asn1.DERSequence;
import org.apache.commons.ssl.asn1.DERSet;
import org.apache.commons.ssl.asn1.DERT61String;
import org.apache.commons.ssl.asn1.DERTaggedObject;
import org.apache.commons.ssl.asn1.DERTags;
import org.apache.commons.ssl.asn1.DERUTCTime;
import org.apache.commons.ssl.asn1.DERUTF8String;
import org.apache.commons.ssl.asn1.DERUniversalString;
import org.apache.commons.ssl.asn1.DERUnknownTag;
import org.apache.commons.ssl.asn1.DERVisibleString;
import org.apache.commons.ssl.asn1.DefiniteLengthInputStream;

public class ASN1InputStream
extends FilterInputStream
implements DERTags {
    private static final DERObject END_OF_STREAM = new DERObject(){

        void encode(DEROutputStream out) throws IOException {
            throw new IOException("Eeek!");
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            return o == this;
        }
    };
    boolean eofFound = false;
    int limit = Integer.MAX_VALUE;

    public ASN1InputStream(InputStream is) {
        super(is);
    }

    public ASN1InputStream(byte[] input) {
        this(new ByteArrayInputStream(input), input.length);
    }

    public ASN1InputStream(InputStream input, int limit) {
        super(input);
        this.limit = limit;
    }

    protected int readLength() throws IOException {
        int length = this.read();
        if (length < 0) {
            throw new IOException("EOF found when length expected");
        }
        if (length == 128) {
            return -1;
        }
        if (length > 127) {
            int size = length & 0x7F;
            if (size > 4) {
                throw new IOException("DER length more than 4 bytes");
            }
            length = 0;
            for (int i = 0; i < size; ++i) {
                int next = this.read();
                if (next < 0) {
                    throw new IOException("EOF found reading length");
                }
                length = (length << 8) + next;
            }
            if (length < 0) {
                throw new IOException("corrupted stream - negative length found");
            }
            if (length >= this.limit) {
                throw new IOException("corrupted stream - out of bounds length found");
            }
        }
        return length;
    }

    protected void readFully(byte[] bytes) throws IOException {
        int len;
        int left = bytes.length;
        if (left == 0) {
            return;
        }
        while ((len = this.read(bytes, bytes.length - left, left)) > 0) {
            if ((left -= len) != 0) continue;
            return;
        }
        if (left != 0) {
            throw new EOFException("EOF encountered in middle of object");
        }
    }

    protected DERObject buildObject(int tag, int tagNo, int length) throws IOException {
        boolean isConstructed;
        if ((tag & 0x40) != 0) {
            return new DERApplicationSpecific(tagNo, this.readDefiniteLengthFully(length));
        }
        boolean bl = isConstructed = (tag & 0x20) != 0;
        if (isConstructed) {
            switch (tag) {
                case 48: {
                    return new DERSequence(this.buildDerEncodableVector(length));
                }
                case 49: {
                    return new DERSet(this.buildDerEncodableVector(length), false);
                }
                case 36: {
                    return this.buildDerConstructedOctetString(length);
                }
            }
            if ((tag & 0x80) != 0) {
                if (length == 0) {
                    return new DERTaggedObject(false, tagNo, new DERSequence());
                }
                ASN1EncodableVector v = this.buildDerEncodableVector(length);
                if (v.size() == 1) {
                    return new DERTaggedObject(tagNo, v.get(0));
                }
                return new DERTaggedObject(false, tagNo, new DERSequence(v));
            }
            return new DERUnknownTag(tag, this.readDefiniteLengthFully(length));
        }
        byte[] bytes = this.readDefiniteLengthFully(length);
        switch (tag) {
            case 5: {
                return DERNull.INSTANCE;
            }
            case 1: {
                return new DERBoolean(bytes);
            }
            case 2: {
                return new DERInteger(bytes);
            }
            case 10: {
                return new DEREnumerated(bytes);
            }
            case 6: {
                return new DERObjectIdentifier(bytes);
            }
            case 3: {
                byte padBits = bytes[0];
                byte[] data = new byte[bytes.length - 1];
                System.arraycopy(bytes, 1, data, 0, bytes.length - 1);
                return new DERBitString(data, (int)padBits);
            }
            case 18: {
                return new DERNumericString(bytes);
            }
            case 12: {
                return new DERUTF8String(bytes);
            }
            case 19: {
                return new DERPrintableString(bytes);
            }
            case 22: {
                return new DERIA5String(bytes);
            }
            case 20: {
                return new DERT61String(bytes);
            }
            case 26: {
                return new DERVisibleString(bytes);
            }
            case 27: {
                return new DERGeneralString(bytes);
            }
            case 28: {
                return new DERUniversalString(bytes);
            }
            case 30: {
                return new DERBMPString(bytes);
            }
            case 4: {
                return new DEROctetString(bytes);
            }
            case 23: {
                return new DERUTCTime(bytes);
            }
            case 24: {
                return new DERGeneralizedTime(bytes);
            }
        }
        if ((tag & 0x80) != 0) {
            if (bytes.length == 0) {
                return new DERTaggedObject(false, tagNo, DERNull.INSTANCE);
            }
            return new DERTaggedObject(false, tagNo, new DEROctetString(bytes));
        }
        return new DERUnknownTag(tag, bytes);
    }

    private byte[] readDefiniteLengthFully(int length) throws IOException {
        byte[] bytes = new byte[length];
        this.readFully(bytes);
        return bytes;
    }

    private byte[] readIndefiniteLengthFully() throws IOException {
        int b;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        int b1 = this.read();
        while ((b = this.read()) >= 0 && (b1 != 0 || b != 0)) {
            bOut.write(b1);
            b1 = b;
        }
        return bOut.toByteArray();
    }

    private BERConstructedOctetString buildConstructedOctetString(DERObject sentinel) throws IOException {
        DERObject o;
        Vector<DERObject> octs = new Vector<DERObject>();
        while ((o = this.readObject()) != sentinel) {
            octs.addElement(o);
        }
        return new BERConstructedOctetString(octs);
    }

    private BERConstructedOctetString buildDerConstructedOctetString(int length) throws IOException {
        DefiniteLengthInputStream dIn = new DefiniteLengthInputStream(this, length);
        ASN1InputStream aIn = new ASN1InputStream(dIn, length);
        return aIn.buildConstructedOctetString(null);
    }

    private ASN1EncodableVector buildEncodableVector(DERObject sentinel) throws IOException {
        DERObject o;
        ASN1EncodableVector v = new ASN1EncodableVector();
        while ((o = this.readObject()) != sentinel) {
            v.add(o);
        }
        return v;
    }

    private ASN1EncodableVector buildDerEncodableVector(int length) throws IOException {
        DefiniteLengthInputStream dIn = new DefiniteLengthInputStream(this, length);
        ASN1InputStream aIn = new ASN1InputStream(dIn, length);
        return aIn.buildEncodableVector(null);
    }

    public DERObject readObject() throws IOException {
        int length;
        int tag = this.read();
        if (tag == -1) {
            if (this.eofFound) {
                throw new EOFException("attempt to read past end of file.");
            }
            this.eofFound = true;
            return null;
        }
        int tagNo = 0;
        if ((tag & 0x80) != 0 || (tag & 0x40) != 0) {
            tagNo = this.readTagNumber(tag);
        }
        if ((length = this.readLength()) < 0) {
            switch (tag) {
                case 5: {
                    return BERNull.INSTANCE;
                }
                case 48: {
                    return new BERSequence(this.buildEncodableVector(END_OF_STREAM));
                }
                case 49: {
                    return new BERSet(this.buildEncodableVector(END_OF_STREAM), false);
                }
                case 36: {
                    return this.buildConstructedOctetString(END_OF_STREAM);
                }
            }
            if ((tag & 0x80) != 0) {
                if ((tag & 0x20) == 0) {
                    byte[] bytes = this.readIndefiniteLengthFully();
                    return new BERTaggedObject(false, tagNo, new DEROctetString(bytes));
                }
                ASN1EncodableVector v = this.buildEncodableVector(END_OF_STREAM);
                if (v.size() == 0) {
                    return new DERTaggedObject(tagNo);
                }
                if (v.size() == 1) {
                    return new BERTaggedObject(tagNo, v.get(0));
                }
                return new BERTaggedObject(false, tagNo, new BERSequence(v));
            }
            throw new IOException("unknown BER object encountered");
        }
        if (tag == 0 && length == 0) {
            return END_OF_STREAM;
        }
        return this.buildObject(tag, tagNo, length);
    }

    private int readTagNumber(int tag) throws IOException {
        int tagNo = tag & 0x1F;
        if (tagNo == 31) {
            int b = this.read();
            tagNo = 0;
            while (b >= 0 && (b & 0x80) != 0) {
                tagNo |= b & 0x7F;
                tagNo <<= 7;
                b = this.read();
            }
            if (b < 0) {
                this.eofFound = true;
                throw new EOFException("EOF found inside tag value.");
            }
            tagNo |= b & 0x7F;
        }
        return tagNo;
    }
}

