/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.binding;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.binding.BindingEndpoint;
import org.apache.camel.impl.UriEndpointComponent;

public class BindingNameComponent
extends UriEndpointComponent {
    protected static final String BAD_FORMAT_MESSAGE = "URI should be of the format binding:nameOfBinding:endpointURI";

    public BindingNameComponent() {
        super(BindingEndpoint.class);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        int idx = remaining.indexOf(":");
        if (idx <= 0) {
            throw new IllegalArgumentException(BAD_FORMAT_MESSAGE);
        }
        String bindingName = remaining.substring(0, idx);
        String delegateURI = remaining.substring(idx + 1);
        if (delegateURI.isEmpty()) {
            throw new IllegalArgumentException(BAD_FORMAT_MESSAGE);
        }
        return new BindingEndpoint(uri, (Component)this, bindingName, delegateURI);
    }
}

