/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Locale;
import org.apache.camel.component.properties.PropertiesFunction;
import org.apache.camel.util.ObjectHelper;

public class ServiceHostPropertiesFunction
implements PropertiesFunction {
    private static final String HOST_PREFIX = "_SERVICE_HOST";

    @Override
    public String getName() {
        return "service.host";
    }

    @Override
    public String apply(String remainder) {
        String key = remainder;
        String defaultValue = null;
        if (remainder.contains(":")) {
            key = ObjectHelper.before(remainder, ":");
            defaultValue = ObjectHelper.after(remainder, ":");
        }
        if (key != null) {
            String host = System.getenv((key = key.toUpperCase(Locale.ENGLISH).replace('-', '_')) + HOST_PREFIX);
            if (host != null) {
                return host;
            }
            return defaultValue;
        }
        return defaultValue;
    }
}

