/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.transformer.TransformerKey;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerRegistry;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class DefaultTransformerRegistry
extends LRUCache<TransformerKey, Transformer>
implements TransformerRegistry<TransformerKey> {
    private static final long serialVersionUID = 1L;
    private ConcurrentMap<TransformerKey, Transformer> staticMap = new ConcurrentHashMap<TransformerKey, Transformer>();
    private ConcurrentMap<TransformerKey, TransformerKey> aliasMap = new ConcurrentHashMap<TransformerKey, TransformerKey>();
    private final CamelContext context;

    public DefaultTransformerRegistry(CamelContext context) throws Exception {
        this(context, new ArrayList<TransformerDefinition>());
    }

    public DefaultTransformerRegistry(CamelContext context, List<TransformerDefinition> definitions) throws Exception {
        super(CamelContextHelper.getMaximumTransformerCacheSize(context), CamelContextHelper.getMaximumTransformerCacheSize(context), false);
        this.context = context;
        for (TransformerDefinition def : definitions) {
            Transformer transformer = def.createTransformer(context);
            context.addService(transformer);
            this.put(this.createKey(def), transformer);
        }
    }

    @Override
    public Transformer resolveTransformer(TransformerKey key) {
        if (ObjectHelper.isEmpty(key.getScheme()) && key.getTo() == null) {
            return null;
        }
        Transformer answer = this.get(this.aliasMap.containsKey(key) ? this.aliasMap.get(key) : key);
        if (answer != null || ObjectHelper.isNotEmpty(key.getScheme())) {
            return answer;
        }
        TransformerKey alias = null;
        if (key.getFrom() != null && ObjectHelper.isNotEmpty(key.getFrom().getName())) {
            alias = new TransformerKey(new DataType(key.getFrom().getModel()), key.getTo());
            answer = this.get(alias);
        }
        if (answer == null && ObjectHelper.isNotEmpty(key.getTo().getName())) {
            alias = new TransformerKey(key.getFrom(), new DataType(key.getTo().getModel()));
            answer = this.get(alias);
        }
        if (answer == null && key.getFrom() != null && ObjectHelper.isNotEmpty(key.getFrom().getName()) && ObjectHelper.isNotEmpty(key.getTo().getName())) {
            alias = new TransformerKey(new DataType(key.getFrom().getModel()), new DataType(key.getTo().getModel()));
            answer = this.get(alias);
        }
        if (answer == null && key.getFrom() != null) {
            alias = new TransformerKey(key.getFrom().getModel());
            answer = this.get(alias);
        }
        if (answer == null) {
            alias = new TransformerKey(key.getTo().getModel());
            answer = this.get(alias);
        }
        if (answer != null) {
            this.aliasMap.put(key, alias);
        }
        return answer;
    }

    @Override
    public void start() throws Exception {
        this.resetStatistics();
    }

    @Override
    public Transformer get(Object o) {
        Transformer answer = (Transformer)this.staticMap.get(o);
        if (answer == null) {
            answer = (Transformer)super.get(o);
        } else {
            this.hits.increment();
        }
        return answer;
    }

    @Override
    public Transformer put(TransformerKey key, Transformer transformer) {
        Transformer answer = (Transformer)this.staticMap.remove(key);
        if (answer != null) {
            this.staticMap.put(key, transformer);
            return answer;
        }
        answer = (Transformer)super.remove(key);
        if (answer != null) {
            super.put(key, transformer);
            return answer;
        }
        answer = this.context.isSetupRoutes() || this.context.isStartingRoutes() ? this.staticMap.put(key, transformer) : super.put(key, transformer);
        return answer;
    }

    @Override
    public void putAll(Map<? extends TransformerKey, ? extends Transformer> map) {
        for (Map.Entry<? extends TransformerKey, ? extends Transformer> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(Object o) {
        return this.staticMap.containsKey(o) || super.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.staticMap.containsValue(o) || super.containsValue(o);
    }

    @Override
    public int size() {
        return this.staticMap.size() + super.size();
    }

    @Override
    public int staticSize() {
        return this.staticMap.size();
    }

    @Override
    public int dynamicSize() {
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        return this.staticMap.isEmpty() && super.isEmpty();
    }

    @Override
    public Transformer remove(Object o) {
        Transformer answer = (Transformer)this.staticMap.remove(o);
        if (answer == null) {
            answer = (Transformer)super.remove(o);
        }
        return answer;
    }

    @Override
    public void clear() {
        this.staticMap.clear();
        super.clear();
    }

    @Override
    public Set<TransformerKey> keySet() {
        LinkedHashSet<TransformerKey> answer = new LinkedHashSet<TransformerKey>();
        answer.addAll(this.staticMap.keySet());
        answer.addAll(super.keySet());
        return answer;
    }

    @Override
    public Collection<Transformer> values() {
        ArrayList<Transformer> answer = new ArrayList<Transformer>();
        answer.addAll(this.staticMap.values());
        answer.addAll(super.values());
        return answer;
    }

    @Override
    public Set<Map.Entry<TransformerKey, Transformer>> entrySet() {
        LinkedHashSet<Map.Entry<TransformerKey, Transformer>> answer = new LinkedHashSet<Map.Entry<TransformerKey, Transformer>>();
        answer.addAll(this.staticMap.entrySet());
        answer.addAll(super.entrySet());
        return answer;
    }

    @Override
    public int getMaximumCacheSize() {
        return super.getMaxCacheSize();
    }

    @Override
    public void purge() {
        super.clear();
    }

    @Override
    public boolean isStatic(String scheme) {
        return this.staticMap.containsKey(new TransformerKey(scheme));
    }

    @Override
    public boolean isStatic(DataType from, DataType to) {
        return this.staticMap.containsKey(new TransformerKey(from, to));
    }

    @Override
    public boolean isDynamic(String scheme) {
        return super.containsKey(new TransformerKey(scheme));
    }

    @Override
    public boolean isDynamic(DataType from, DataType to) {
        return super.containsKey(new TransformerKey(from, to));
    }

    @Override
    public void stop() throws Exception {
        ServiceHelper.stopServices(this.staticMap.values());
        ServiceHelper.stopServices(this.values());
        this.purge();
    }

    @Override
    public String toString() {
        return "TransformerRegistry for " + this.context.getName() + ", capacity: " + this.getMaxCacheSize();
    }

    private TransformerKey createKey(TransformerDefinition def) {
        return ObjectHelper.isNotEmpty(def.getScheme()) ? new TransformerKey(def.getScheme()) : new TransformerKey(new DataType(def.getFromType()), new DataType(def.getToType()));
    }
}

