/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class ConvertBodyProcessor
extends ServiceSupport
implements AsyncProcessor,
IdAware {
    private String id;
    private final Class<?> type;
    private final String charset;

    public ConvertBodyProcessor(Class<?> type) {
        ObjectHelper.notNull(type, "type", this);
        this.type = type;
        this.charset = null;
    }

    public ConvertBodyProcessor(Class<?> type, String charset) {
        ObjectHelper.notNull(type, "type", this);
        this.type = type;
        this.charset = IOHelper.normalizeCharset(charset);
    }

    public String toString() {
        return "convertBodyTo[" + this.type.getCanonicalName() + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean copyNeeded;
        Object value;
        Message old;
        boolean out = exchange.hasOut();
        Message message = old = out ? exchange.getOut() : exchange.getIn();
        if (old.getBody() == null) {
            callback.done(true);
            return true;
        }
        if (exchange.getException() != null) {
            callback.done(true);
            return true;
        }
        if (this.charset != null) {
            exchange.setProperty("CamelCharsetName", this.charset);
        }
        try {
            value = old.getMandatoryBody(this.type);
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        boolean bl = copyNeeded = !old.getClass().equals(DefaultMessage.class);
        if (copyNeeded) {
            DefaultMessage msg = new DefaultMessage(exchange.getContext());
            msg.copyFromWithNewBody(old, value);
            ExchangeHelper.replaceMessage(exchange, msg, false);
        } else {
            old.setBody(value);
        }
        if (this.charset != null) {
            exchange.removeProperty("CamelCharsetName");
        }
        callback.done(true);
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

